% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{PlotCoefs}
\alias{PlotCoefs}
\title{Plots Estimated Coefficients}
\usage{
PlotCoefs(
  points = NULL,
  bounds = NULL,
  intervals = NULL,
  distributions = NULL,
  newPlot = TRUE,
  xlim = NULL,
  ylim = NULL,
  boundFun = function(b, type) {
     if (type == "xmin" || type == "ymin") {
        
    0.9 * b
     }
     else {
         1.1 * b
     }
 },
  legendsTitle = c("Point", "Bound", "Interval", "Density"),
  legendTitleCex = 1.1,
  legendSize = 5,
  ...
)
}
\arguments{
\item{points}{(list of list) each element is a point estimation to be drawn
as a shape; defined by 1.\code{value}, 2.\code{y} (default=0), 3.\code{shape}
(default="circle"), ...}

\item{bounds}{(list of list) each element is a bound estimation (e.g.
extreme bound analysis) to be drawn as a rectangle; defined by 1.\code{xmin},
2.\code{xmax}, 3.\code{ymin} (default=-0.1), 4.\code{ymax}, (default=+0.1), 5.\code{alpha}, ...}

\item{intervals}{(list of list) each element is an interval estimation
(similar to \code{bounds} but with a value) to be drawn as an interval;
defined by 1.\code{value}, 2.\code{xmin}, 3.\code{xmax}, ...}

\item{distributions}{(list of list) each element is a distribution estimation
(eg., a known distribution) to be drawn as its density function; defined by 1.\code{type},
and for \code{type=normal}, 2.\code{mean}, 3.\code{var}, 4.\code{sdMultiplier}, for
\code{type=GLD}, 2.\code{p1},..., 5.\code{p4}, 6.\code{quantiles}, for \code{type==cdfs}
2.\code{xs}, 3.\code{cdfs}, 4.\code{smoothFun}, ...}

\item{newPlot}{(logical) if \code{TRUE}, a new plot is initialized.}

\item{xlim}{(numeric vector) two limits for the x axis. If \code{NULL}, it is auto generated.}

\item{ylim}{(numeric vector) two limits for the y axis. If \code{NULL}, it is auto generated.}

\item{boundFun}{(function) a function to control the \code{xlim} and \code{ylim}
in the \code{plot}. Its arguments are the computed bounds.}

\item{legendsTitle}{(list) a list of titles for legends.}

\item{legendTitleCex}{(numeric) sets \code{title.cex} in legends.}

\item{legendSize}{(numeric) size of the legend (width or height)
in lines of text (it is passed to \code{oma}).}

\item{...}{additional properties for plot or legend: \code{xlab}, \code{ylab}}
}
\value{
if \code{plot} is \code{FALSE}, a \code{ggplot} to be printed.
}
\description{
Plots Estimated Coefficients
}
\examples{
points <- list()
points$one <- list(value = 1, label = "Point 1")
points$two <- list(value = 2, label = "Point 2", col = "red", pch = 22, cex = 4)
PlotCoefs(points = points)

bounds <- list()
bounds$one <- list(xmin = -1, xmax = 0.5, label = "Bound 1")
bounds$two <- list(
  xmin = 0, xmax = 1, ymin = 0.2, ymax = 0.3,
  label = "Bound 2", alpha = 0.2, col = rgb(0, 0, 1.0, alpha = 0.3)
)
PlotCoefs(points = points, bounds = bounds)

intervals <- list()
intervals$one <- list(value = 2, xmin = 0, xmax = 3, label = "Interval 1")
intervals$two <- list(
  value = 1.5, xmin = 1, xmax = 2, y = 4,
  label = "Interval 2", col = "blue", lwd = 3, pch = 11, cex = c(1.2, 3, 1.2)
)
PlotCoefs(points = points, bounds = bounds, intervals = intervals)

distributions <- list()
distributions$one <- list(type = "normal", mean = 0, var = 1, label = "Distribution 1")
distributions$two <- list(
  type = "gld", p1 = 0, p2 = 1.5, p3 = 1.2,
  p4 = 1.2, label = "Distribution 2", col = "blue", lwd = 3
)
distributions$three <- list(
  type = "cdfs", xs = seq(-2, 2, 0.1),
  cdfs = pnorm(seq(-2, 2, 0.1)), label = "Distribution 3",
  col = rgb(1, 0, 0, alpha = 0.5), lwd = 8
)
PlotCoefs(
  points = points, bounds = bounds, intervals = intervals,
  distributions = distributions, legendsTitle = NULL, legendSize = 7
)

}
