% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{VarmaEstim}
\alias{VarmaEstim}
\title{Estimates an VARMA Model}
\usage{
VarmaEstim(
  y,
  x = NULL,
  params = NULL,
  seasonsCount = 0L,
  addIntercept = TRUE,
  lmbfgsOptions = NULL,
  olsStdMultiplier = 2,
  pcaOptionsY = NULL,
  pcaOptionsX = NULL,
  maxHorizon = 0L,
  newX = NULL,
  simFixSize = 0L,
  simHorizons = NULL,
  simUsePreviousEstim = TRUE,
  simMaxConditionNumber = 1e+20,
  printMsg = FALSE
)
}
\arguments{
\item{y}{(matrix) endogenous data with variables in the columns.}

\item{x}{(matrix) exogenous data with variables in the columns.}

\item{params}{(integer vector, length=6) parameters of the VARMA model (p,d,q,P,D,Q).}

\item{seasonsCount}{(integer) number of observations per unit of time}

\item{addIntercept}{(logical) if \code{TRUE}, intercept is added automatically to x.}

\item{lmbfgsOptions}{(list) optimization options. See \code{[GetLmbfgsOptions()]}.}

\item{olsStdMultiplier}{(numeric) a multiplier for the standard deviation of OLS, used for restricting the maximum likelihood estimation.}

\item{pcaOptionsY}{(list) a list of options in order to use principal components of the \code{y}, instead of the actual values. set \code{NULL} to disable. Use \code{[GetPcaOptions()]} for initialization.}

\item{pcaOptionsX}{(list) similar to \code{pcaOptionsY} but for \code{x}. see \code{pcaOptionsY}.}

\item{maxHorizon}{(integer) maximum prediction horizon. Set zero to disable.}

\item{newX}{(matrix) data of new exogenous variables to be used in the predictions. Its columns must be the same as \code{x}.}

\item{simFixSize}{(integer) number of pseudo out-of-sample simulations. Use zero to disable the simulation. see also \code{[GetMeasureOptions()]}.}

\item{simHorizons}{(integer vector) prediction horizons to be used in pseudo out-of-sample simulations. see also \code{[GetMeasureOptions()]}.}

\item{simUsePreviousEstim}{(logical) if \code{TRUE}, parameters are initialized in just the first step of the simulation. The initial values of the n-th simulation (with one more observation) is the estimations in the previous step.}

\item{simMaxConditionNumber}{(numeric) maximum value for the condition number in the pseudo out-of-sample simulations.}

\item{printMsg}{(logical) set \code{FALSE} to disable printing the details.}
}
\value{
A list:
}
\description{
Estimates an VARMA Model
}
