% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{latex.variable.vector}
\alias{latex.variable.vector}
\title{Generate LaTeX code for a variable vector}
\usage{
latex.variable.vector(
  vec_size,
  label,
  intercept = FALSE,
  max_size = 3,
  env = "pmatrix"
)
}
\arguments{
\item{vec_size}{An integer specifying the size of the vector.}

\item{label}{A character string specifying the label to use when filling the cell values.}

\item{intercept}{A logical value indicating whether to add \code{1} to the vector.}

\item{max_size}{An integer specifying the maximum size of the vector before using \verb{\\\\vdots} to remove middle elements.}

\item{env}{A character string specifying the matrix environment to use.
Possible values are "bmatrix", "pmatrix", "Bmatrix", "vmatrix", and "Vmatrix".}
}
\value{
A character string containing the LaTeX code for the vector.
}
\description{
Generate LaTeX code for a variable vector
}
\examples{
#latex.variable.vector(3, "X")
#latex.variable.vector(5, "X")
#latex.variable.vector(5, "X", intercept = FALSE)
}
