% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R
\name{summary.ldtsearch}
\alias{summary.ldtsearch}
\title{Summarizes Model Search Output}
\usage{
\method{summary}{ldtsearch}(
  object,
  y,
  x = NULL,
  addModelBests = TRUE,
  addModelAll = FALSE,
  addItem1Bests = FALSE,
  printMsg = FALSE,
  w = NULL,
  newX = NULL,
  test = FALSE,
  ...
)
}
\arguments{
\item{object}{Output from one of the \code{search.?} functions (see \link{search.sur}, \link{search.varma}, or \link{search.bin}).}

\item{y}{Data for dependent variables (Note that data is not saved in \code{object}).}

\item{x}{Data for exogenous variables (Note that data is not saved in \code{object}).}

\item{addModelBests}{If \code{TRUE} and search output contains best models, estimates them.}

\item{addModelAll}{If \code{TRUE} and search output contains all models, estimates them.}

\item{addItem1Bests}{If \code{TRUE} and search output contains \code{item1} part, estimates them.}

\item{printMsg}{If \code{TRUE}, prints details.}

\item{w}{Weight of observations in discrete choice estimation (Note that data is not saved in \code{object}).}

\item{newX}{New exogenous data in VARMA estimation (Note that data is not saved in \code{object}).}

\item{test}{If \code{TRUE}, verifies everything is working correctly. Please report errors.}

\item{...}{Additional arguments}
}
\value{
A list with estimated models and other information, structured similarly to the given \code{search.?} output.
}
\description{
This function estimates the reported models in the output of a \code{search.?} function and provides additional information.
}
\details{
The output of \code{search.?} functions in this package only contains the information required
to re-estimate the models, not the actual estimation results. You can use \link{h.get.estim} to
get the estimation of specific indices. This function re-estimates everything in the \code{search.?}
output with a similar structure.
}
