% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varma.R
\name{sim.varma}
\alias{sim.varma}
\title{Generate Random Sample from a VARMA Model}
\usage{
sim.varma(
  sigma = 2L,
  arList = 1L,
  maList = 0L,
  exoCoef = 0L,
  nObs = 100,
  nBurn = 10,
  intercept = TRUE,
  d = 0,
  numFormat = "\%.2f",
  startFrequency = NULL,
  seasonalCoefs = NULL
)
}
\arguments{
\item{sigma}{A positive definite matrix representing the covariance matrix of the white noise series or an integer representing the dimension of a random covariance matrix to generate.}

\item{arList}{A list of matrices representing the AR coefficients of the VARMA model or an integer representing the number of random AR coefficients to generate.}

\item{maList}{A list of matrices representing the MA coefficients of the VARMA model or an integer representing the number of random MA coefficients to generate. For identification purposes, it generates diagonal matrices.}

\item{exoCoef}{A matrix representing the coefficients of the exogenous variables or an integer representing the number of random exogenous coefficients to generate.}

\item{nObs}{An integer representing the number of observations to generate.}

\item{nBurn}{An integer representing the number of burn-in observations to remove from the generated time series.}

\item{intercept}{A numeric vector representing the intercept of the VARMA model or a logical value indicating whether to generate a random intercept.}

\item{d}{An integer representing the order of integration.}

\item{numFormat}{A character string that determines how to format the numbers, to be used as the argument of the \code{sprintf} function.
If \code{NULL}, conversion to latex or html representations are disabled.}

\item{startFrequency}{The frequency of the first observation in the data.}

\item{seasonalCoefs}{An integer vector of size 4: \code{(P,D,Q,s)} where
\code{P} is the number of random seasonal AR coefficients to generate,
\code{Q} is the number of random seasonal MA coefficients to generate,
\code{D} is the order of seasonal integration,
and \code{s} is the number of seasons.
These are effective if \code{arList} and \code{maList} are randomly generated within the function.}
}
\value{
A list with the following items:
\item{y}{The simulated endogenous data.}
\item{x}{The simulated exogenous data.}
\item{e}{The simulated white noise series.}
\item{sigma}{The covariance matrix of the white noise series.}
\item{arList}{The list of autoregressive coefficients.}
\item{maList}{The list of moving average coefficients.}
\item{exoCoef}{The matrix of exogenous coefficients.}
\item{intercept}{The intercept vector.}
\item{d}{The order of the integration.}
\item{seasonalCoefs}{The argument \code{seasonalCoefs} }
\item{nObs}{The number of observations generated.}
\item{nBurn}{The number of burn-in observations removed.}
\item{eqsLatex}{character string, Latex representation of the equations of the system.}
\item{eqsLatexSys}{character string, Latex representation of the system in matrix form.}
}
\description{
This function generates a multivariate time series using a VARMA process.
}
\examples{
sample1 <- sim.varma(2L, 3L, 2L)

ar1 <- matrix(c(0.7,0.2,-0.4,0.3),2,2)
ar2 <- matrix(c(-0.4,0.1,0.2,-0.3),2,2)
ma1 <- matrix(c(0.5,-0.1,0.3,0.4),2,2)
Sigma <- matrix(c(1,0.3,0.3,1),2,2)
B <- matrix(c(0.5,-0.3),2)

sample2 <- sim.varma(Sigma, list(ar1, ar2), list(ma1), exoCoef = B ,
                    nObs =100, nBurn =10 , intercept = c(1,-1))

# Plot the y series
matplot(sample2$y,type = "l")
}
