% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure-path.R
\name{enableMeasurePath}
\alias{enableMeasurePath}
\alias{measurePathOptions}
\alias{addMeasurePathToolbar}
\title{Enables measuring of length of polylines and areas of polygons}
\usage{
enableMeasurePath(map)

measurePathOptions(showOnHover = FALSE, minPixelDistance = 30,
  showDistances = TRUE, showArea = TRUE, imperial = FALSE)

addMeasurePathToolbar(map, options = measurePathOptions())
}
\arguments{
\item{map}{The map widget.}

\item{showOnHover}{If TRUE, the measurements will only show when the user hovers the cursor over the path.}

\item{minPixelDistance}{The minimum length a line segment in the feature must have for a measurement to be added.}

\item{showDistances}{If FALSE, doesn't show distances along line segments of of a polyline/polygon.}

\item{showArea}{If FALSE, doesn't show areas of a polyline/polygon.}

\item{imperial}{If TRUE the distances/areas will be shown in imperial units.}

\item{options}{The measurePathOptions.}
}
\description{
Enables measuring of length of polylines and areas of polygons

Options for measure-path

Adds a toolbar to enable/disable measuing path distances/areas
}
\examples{
\donttest{geoJson <- readr::read_file(
  "https://rawgit.com/benbalter/dc-maps/master/maps/ward-2012.geojson"
)

leaflet() \%>\%
  addTiles() \%>\%
  setView(-77.0369, 38.9072, 11) \%>\%
  addBootstrapDependency() \%>\%
  enableMeasurePath() \%>\%
  addGeoJSONChoropleth(
    geoJson,
    valueProperty = "AREASQMI",
    scale = c("white","red"),
    mode = "q",
    steps = 4,
    padding = c(0.2,0),
    labelProperty = "NAME",
    popupProperty = propstoHTMLTable(
      props = c("NAME", "AREASQMI", "REP_NAME", "WEB_URL", "REP_PHONE", "REP_EMAIL", "REP_OFFICE"),
      table.attrs = list(class = "table table-striped table-bordered"),
      drop.na = TRUE
    ),
    color = "#ffffff", weight = 1, fillOpacity = 0.7,
    highlightOptions = highlightOptions(
      weight = 2, color = "#000000",
      fillOpacity = 1, opacity = 1,
      bringToFront = TRUE, sendToBack = TRUE),
    pathOptions = pathOptions(
      showMeasurements = TRUE,
      measurementOptions = measurePathOptions(imperial = TRUE)))}


}
