% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wms-legend.R
\name{addWMSLegend}
\alias{addWMSLegend}
\title{Add WMS Legend}
\usage{
addWMSLegend(map, uri, position = "topright", layerId = NULL)
}
\arguments{
\item{map}{The leaflet map}

\item{uri}{The legend URI}

\item{position}{position of control: "topleft", "topright", "bottomleft", or "bottomright"}

\item{layerId}{A unique ID for the Legend}
}
\description{
Add a WMS Legend
}
\examples{
leaflet(
  options = leafletOptions(
    center = c(-33.95293, 20.82824),
    zoom = 14,
    minZoom = 5,
    maxZoom = 18,
    maxBounds = list(
      c(-33.91444, 20.75351),
      c(-33.98731, 20.90626)
    )
  )
) \%>\%
  addWMSTiles(
    baseUrl = paste0(
      "http://maps.kartoza.com/web/?",
      "map=/web/Boosmansbos/Boosmansbos.qgs"
    ),
    layers = "Boosmansbos",
    options = WMSTileOptions(format = "image/png", transparent = TRUE),
    attribution = paste0(
      "(c)<a href= \\"http://kartoza.com\\">Kartoza.com</a> and ",
      "<a href= \\"http://www.ngi.gov.za/\\">SA-NGI</a>"
    )
  ) \%>\%
  addWMSLegend(
    uri = paste0(
      "http://maps.kartoza.com/web/?",
      "map=/web/Boosmansbos/Boosmansbos.qgs&&SERVICE=WMS&VERSION=1.3.0",
      "&SLD_VERSION=1.1.0&REQUEST=GetLegendGraphic&FORMAT=image/jpeg&LAYER=Boosmansbos&STYLE="
    )
  )
}
