% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openweather.R
\name{addOpenweatherCurrent}
\alias{addOpenweatherCurrent}
\title{Add current OpenWeatherMap Marker}
\usage{
addOpenweatherCurrent(
  map,
  apikey = NULL,
  group = NULL,
  layerId = NULL,
  options = openweatherCurrentOptions()
)
}
\arguments{
\item{map}{a map widget object created from \code{\link[leaflet]{leaflet}()}}

\item{apikey}{a valid Openweathermap-API key.}

\item{group}{the name of the group the newly created layers should belong to
(for \code{\link[leaflet]{clearGroup}} and \code{\link[leaflet]{addLayersControl}} purposes).
Human-friendly group names are permitted--they need not be short,
identifier-style names. Any number of layers and even different types of
layers (e.g. markers and polygons) can share the same group name.}

\item{layerId}{the layer id}

\item{options}{List of further options. See
\code{\link{openweatherCurrentOptions}}}
}
\value{
the new \code{map} object
}
\description{
Add current OpenWeatherMap Marker
}
\note{
The current weather icons will appear beginning with zoom level 9
and if used in Shiny, a click on an icon will update a Shiny input at
\code{input$MAPID_owm_click}.
}
\examples{
\dontrun{
library(leaflet)
library(leaflet.extras2)

Sys.setenv("OPENWEATHERMAP" = "Your_API_Key")

leaflet() \%>\%
  addTiles() \%>\%
  setView(9, 50, 9) \%>\%
  addOpenweatherCurrent(options = openweatherCurrentOptions(
    lang = "en", popup = TRUE
  ))
}
}
\references{
\url{https://github.com/trafficonese/leaflet-openweathermap}
}
\seealso{
Other Openweathermap Functions: 
\code{\link{addOpenweatherTiles}()},
\code{\link{openweatherCurrentOptions}()},
\code{\link{openweatherOptions}()}
}
\concept{Openweathermap Functions}
