% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leafletsync.R
\name{isSynced}
\alias{isSynced}
\title{Is a map synchronized?}
\usage{
isSynced(map, id = NULL, syncwith = NULL)
}
\arguments{
\item{map}{the map}

\item{id}{The map id}

\item{syncwith}{Is the map synchronized with one of these maps?}
}
\value{
A map
}
\description{
Is a map snychronized with any or a specific map?
Invoking this method sets a Shiny input that returns \code{TRUE} when
the map is synchronized with another map. If \code{syncwith} is
set, \code{TRUE} is returned if the map is synchronized exactly
with that other map.
}
\details{
The Siny input name is combined of the map-id and \code{"_synced"}.
For a map with id \code{map1} the input can be retrieved with
\code{input$map1_synced}.
}
\seealso{
Other leafletsync Functions: 
\code{\link{addLeafletsync}()},
\code{\link{addLeafletsyncDependency}()},
\code{\link{leafletsyncOptions}()},
\code{\link{unsync}()}
}
\concept{leafletsync Functions}
