% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_flows.R
\name{addFlows}
\alias{addFlows}
\alias{updateFlows}
\alias{removeFlows}
\alias{clearFlows}
\title{Add or modify flows on a leaflet map}
\usage{
addFlows(map, lng0, lat0, lng1, lat1, color = "blue", flow = 1,
  opacity = 1, dir = NULL, time = NULL, popup = NULL, layerId = NULL,
  timeFormat = NULL, initialTime = NULL, maxFlow = max(abs(flow)),
  minThickness = 1, maxThickness = 20)

updateFlows(map, layerId, color = NULL, flow = NULL, opacity = NULL,
  dir = NULL, time = NULL, popup = NULL, timeFormat = NULL,
  initialTime = NULL, maxFlow = NULL, minThickness = 1,
  maxThickness = 20)

removeFlows(map, layerId)

clearFlows(map)
}
\arguments{
\item{map}{A leaflet map object created with \code{\link[leaflet]{leaflet}}.}

\item{lng0}{Longitude of the origin of the flow.}

\item{lat0}{Lattitude of the origin of the flow.}

\item{lng1}{Longitude of the destination of the flow.}

\item{lat1}{Lattitude of the destination of the flow.}

\item{color}{Color of the flow.}

\item{flow}{Value of the flow between the origin and the destination. If
argument \code{dir} is not set, negative values are interpreted as flows
from destination to origin.}

\item{opacity}{Opacity of the flow.}

\item{dir}{Direction of the flow. 1 indicates that the flow goes from origin
to destination and -1 indicates that it goes from destination to origin. If
0, the arrow is not drawn. If \code{NULL}, then it is equal to the sign of
\code{weight}.}

\item{time}{A vector with length equal to the number of rows in \code{chartdata}
and containing either numbers representing time indices or dates or
datetimes. Each unique value must appear as many times as the others. This
parameter can be used when one wants to represent the evolution of some
variables on a map.}

\item{popup}{Content of the popup bind to a given chart. This can be html
text.}

\item{layerId}{An ID variable. It is mandatoy when one wants to update some
chart with \code{updateMinicharts}.}

\item{timeFormat}{Character string used to format dates and times when
argument \code{time} is a \code{Date}, \code{POSIXct} or \code{POSIXlt}
object. See \code{\link[base]{strptime}} for more information.}

\item{initialTime}{This argument can be used to set the initial time step
shown when the map is created. It is used only when argument \code{time} is
set.}

\item{maxFlow}{Maximal value a flow could take.}

\item{minThickness}{minimal thickness of the line that represents the flow.}

\item{maxThickness}{maximal thickness of the line that represents the flow.}
}
\value{
The modified leaflet map object.
}
\description{
These functions can be used to represent flows and their evolution on a map
created with \code{\link[leaflet]{leaflet}()}. Flows are simply represented
by a segment between two points with an arrow at its center that indicates the
direction of the flow.
}
\examples{

require(leaflet)

# Toy example
leaflet() \%>\% addTiles() \%>\%
  addFlows(0, 0, 1, 1, flow = 10)

# Electric exchanges between France and neighbouring countries
data("eco2mixBalance")
bal <- eco2mixBalance
leaflet() \%>\% addTiles() \%>\%
  addFlows(
    bal$lng0, bal$lat0, bal$lng1, bal$lat1,
    flow = bal$balance,
    time = bal$month
  )


}
