% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{addRasterLegend}
\alias{addRasterLegend}
\title{Add a color legend for a SpatRaster to a map}
\usage{
addRasterLegend(map, x, layer = 1, ...)
}
\arguments{
\item{map}{a map widget object}

\item{x}{a \link[terra:SpatRaster-class]{SpatRaster} object with a color table}

\item{layer}{the layer of the raster to target}

\item{...}{additional arguments to pass through to \code{\link[=addLegend]{addLegend()}}}
}
\description{
A function for adding a \link[=addLegend]{legend} that is specifically designed
for \link[terra:SpatRaster-class]{terra::SpatRaster} objects, with categorical values, that carry their
own \link[terra:colors]{color table}.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

library(terra)

r <- rast("/vsicurl/https://geodata.ucdavis.edu/test/pr_nlcd.tif")
leaflet() \%>\%
  addTiles() \%>\%
  addRasterImage(r, opacity = 0.75) \%>\%
  addRasterLegend(r, opacity = 0.75)

plot.new() # pause in interactive mode

rr <- r
levels(rr)  <- NULL
leaflet() \%>\%
  addTiles() \%>\%
  addRasterImage(rr, opacity = 0.75) \%>\%
  addRasterLegend(rr, opacity = 0.75)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=addRasterImage]{addRasterImage()}}
}
