% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datamanag.R
\name{verticalize3}
\alias{verticalize3}
\title{Create Historical Vertical Data Frames From Horizontal Data Frames}
\usage{
verticalize3(
  data,
  noyears,
  firstyear,
  popidcol = 0,
  patchidcol = 0,
  individcol = 0,
  blocksize,
  xcol = 0,
  ycol = 0,
  juvcol = 0,
  size1col,
  size2col = 0,
  size3col = 0,
  repstr1col = 0,
  repstr2col = 0,
  fec1col = 0,
  fec2col = 0,
  alive1col = 0,
  dead1col = 0,
  obs1col = 0,
  nonobs1col = 0,
  censorcol = 0,
  repstrrel = 1,
  fecrel = 1,
  stageassign = NA,
  stagesize = NA,
  censorkeep = 1,
  censor = FALSE,
  spacing = NA,
  NAas0 = FALSE,
  NRasRep = FALSE,
  reduce = TRUE
)
}
\arguments{
\item{data}{The horizontal data file.}

\item{noyears}{The number of years or observation periods in the dataset.}

\item{firstyear}{The first year or time of observation.}

\item{popidcol}{A variable name or column number corresponding to the identity
of the population for each individual.}

\item{patchidcol}{A variable name or column number corresponding to the
identity of the patch for each individual, if patches have been designated
within populations.}

\item{individcol}{A variable name or column number corresponding to the
identity of each individual.}

\item{blocksize}{The number of variables corresponding to each time step in 
the input dataset designated in \code{data}.}

\item{xcol}{A variable name or column number corresponding to the x 
coordinate of each individual in Cartesian space.}

\item{ycol}{A variable name or column number corresponding to the y 
coordinate of each individual in Cartesian space.}

\item{juvcol}{A variable name or column number that marks individuals in
immature stages within the dataset. The \code{verticalize3()} function assumes 
that immature individuals are identified in this variable marked with a 
number equal to or greater than 1, and that mature individuals are marked 
as 0 or NA.}

\item{size1col}{A variable name or column number corresponding to the
size entry associated with the first year or observation time in the dataset.}

\item{size2col}{A second variable name or column number corresponding to the
size entry associated with the first year or observation time in the dataset.}

\item{size3col}{A third variable name or column number corresponding to the
size entry associated with the first year or observation time in the dataset.}

\item{repstr1col}{A variable name or column number corresponding to the
production of reproductive structures, such as flowers, associated with the 
first year or observation period in the input dataset. This can be binomial or 
count data, and is used to in analysis of the probability of reproduction.}

\item{repstr2col}{A second variable name or column number corresponding to
the production of reproductive structures, such as flowers, associated with
the first year or observation period in the input dataset. This can be  
binomial or count data, and is used to in analysis of the probability of
reproduction.}

\item{fec1col}{A variable name or column number denoting fecundity associated
with the first year or observation time in the input dataset. This may
represent egg counts, fruit counts, seed production, etc.}

\item{fec2col}{A second variable name or column number denoting fecundity
associated with the first year or observation time in the input dataset. This 
may represent egg counts, fruit counts, seed production, etc.}

\item{alive1col}{A variable name or column number that provides information
an whether an individual is alive at a given time. If used, living status
must be designated as binomial (living = 1, dead = 0).}

\item{dead1col}{A variable name or column number that provides information
an whether an individual is alive at a given time. If used, dead status
must be designated as binomial (dead = 1, living = 0).}

\item{obs1col}{A variable name or column number providing information on
whether an individual is in an observable stage at a given time. If used,
observation status must be designated as binomial (observed = 1, not 
observed = 0).}

\item{nonobs1col}{A variable name or column number providing information on
whether an individual is in an unobservable stage at a given time. If used,
observation status must be designated as binomial (observed = 0, not 
observed = 1).}

\item{censorcol}{A variable name or column number corresponding to 
the first entry of a censor variable, used to distinguish between entries to 
use and entries not to use, or to designate entries with special issues that 
require further attention. If used, this should be associated with the first 
year or observation time, and all other years or times must also have censor 
columns.}

\item{repstrrel}{This is a scalar modifier for that makes the variable in
\code{repstr2col} equivalent to \code{repstr1col}. This can be useful if two 
reproductive status variables have related but unequal units, for example
if \code{repstr1col} refers to one-flowered stems while \code{repstr2col} refers to
two-flowered stems.}

\item{fecrel}{This is a scalar modifier for that makes the variable in
\code{fec2col} equivalent to \code{fec1col}. This can be useful if two fecundity
variables have related but unequal units.}

\item{stageassign}{The stageframe object identifying the life history model
being operationalized.}

\item{stagesize}{A variable name or column number describing which size
variable to use in stage estimation. Defaults to NA, and can also take
\code{sizea}, \code{sizeb}, \code{sizec}, or \code{sizeadded}, depending on which size variable 
is chosen.}

\item{censorkeep}{The value of the censoring variable identifying data
that should be included in analysis. Defaults to 1, but may take any value
including NA.}

\item{censor}{A logical variable determining whether the output data
should be censored using the variable defined in \code{censorcol}. Defaults
to FALSE.}

\item{spacing}{The spacing at which density should be estimated, if density
estimation is desired and x and y coordinates are supplied. Given in the
same units as those used in the x and y coordinates given in \code{xcol} and
\code{ycol}. Defaults to NA.}

\item{NAas0}{If TRUE, then all NA entries for size and fecundity variables
will be set to 0. This can help increase the sample size analyzed by
\code{\link{modelsearch}()}, but should only be used when it is clear that this
substitution is biologically realistic. Defaults to FALSE.}

\item{NRasRep}{If TRUE, then will treat non-reproductive but mature
individuals as reproductive during stage assignment. This can be useful,
for example, when a matrix is desired without separation of reproductive
and non-reproductive but mature stages of the same size. Only used if
\code{stageassign} is set to a stageframe. Defaults to FALSE.}

\item{reduce}{A logical variable determining whether invariant state
variables should be removed from the output dataset. For example, if
all living individuals are always observable, then variables identifying
observation status are invariant and can be removed. Defaults to TRUE.}
}
\value{
If all inputs are properly formatted, then this function will output
a historical vertical data frame, meaning that the output data frame will have
three consecutive years of size and reproductive data per individual per row.
This data frame is in standard format for all functions used in \code{lefko3},
and so can be used without further modification.

Variables in this data frame include the following:
\item{rowid}{Unique identifier for the row of the data frame.}
\item{popid}{Unique identifier for the population, if given.}
\item{patchid}{Unique identifier for patch within population, if
given.}
\item{individ}{Unique identifier for the individual.}
\item{year2}{Year or time step at time \emph{t}.}
\item{xpos,ypos}{X and Y position in Cartesian space, if given.}
\item{sizea1,sizea2,sizea3}{Main size measurement in times \emph{t}-1, 
\emph{t}, and \emph{t}+1, respectively.}
\item{sizeb1,sizeb2,sizeb3}{Secondary size measurement in times 
\emph{t}-1, \emph{t}, and \emph{t}+1, respectively.}
\item{sizec1,sizec2,sizec3}{Tertiary measurement in times \emph{t}-1, 
\emph{t}, and \emph{t}+1, respectively.}
\item{censor1,censor2,censor3}{Censor state values in times \emph{t}-1,
\emph{t}, and \emph{t}+1.}
\item{repstra1,repstrb1,repstrc1}{Main, secondary, and tertiary numbers of 
reproductive structures in time \emph{t}-1.}
\item{repstra2,repstrb2,repstrc2}{Main, secondary, and tertiary numbers of 
reproductive structures in time \emph{t}.}
\item{repstra3,repstrb3,repstrc3}{Main, secondary, and tertiary numbers of 
reproductive structures in time \emph{t}+1.}
\item{feca1,fecb1}{Main and secondary numbers of offspring in time 
\emph{t}-1.}
\item{feca2,fecb2}{Main and secondary numbers of offspring in time 
\emph{t}.}
\item{feca3,fecb3}{Main and secondary numbers of offspring in time 
\emph{t}+1.}
\item{size1added,size2added,size3added}{Sum of primary, secondary, and
tertiary size measurements in timea \emph{t}-1, \emph{t}, and \emph{t}+1, 
respectively.}
\item{repstr1added,repstr2added,repstr3added}{Sum of primary, secondary,
and tertiary reproductive structures in times \emph{t}-1, \emph{t}, and 
\emph{t}+1, respectively.}
\item{fec1added,fec2added,fec3added}{Sum of primary and secondary 
fecundity in times \emph{t}-1, \emph{t}, and \emph{t}+1, respectively.}
\item{obsstatus1,obsstatus2,obsstatus3}{Binomial observation state in times
\emph{t}-1, \emph{t}, and \emph{t}+1, respectively.}
\item{repstatus1,repstatus2,repstatus3}{Binomial reproductive state in 
times \emph{t}-1, \emph{t}, and \emph{t}+1, respectively.}
\item{fecstatus1,fecstatus2,fecstatus3}{Binomial offspring production
state in times \emph{t}-1, \emph{t}, and \emph{t}+1, respectively.}
\item{firstseen}{Year or time step of first observation.}
\item{lastseen}{Year or time step of last observation.}
\item{xcorr,ycorr}{Overall x and y coordinates of individual in
Cartesian space.}
\item{alive1,alive2,alive3}{Binomial state as alive in times \emph{t}-1, 
\emph{t}, and \emph{t}+1, respectively.}
\item{obsage}{Observed age in time \emph{t}, assuming first observation
corresponds to age = 0.}
\item{obslifespan}{Observed lifespan, given as `lastseen - firstseen + 1`.}
\item{matstatus1,matstatus2,matstatus3}{Binomial state as mature.}
\item{density}{Density of individuals per unit designated in `spacing`.
Only given if spacing is not NA.}
}
\description{
\code{verticalize3()} returns a vertically formatted demographic data frame 
organized to create historical projection matrices, given a horizontally
formatted input data frame.
}
\examples{
data(lathyrus)

sizevector <- c(0, 100, 13, 127, 3730, 3800, 0)
stagevector <- c("Sd", "Sdl", "VSm", "Sm", "VLa", "Flo", "Dorm")
repvector <- c(0, 0, 0, 0, 0, 1, 0)
obsvector <- c(0, 1, 1, 1, 1, 1, 0)
matvector <- c(0, 0, 1, 1, 1, 1, 1)
immvector <- c(1, 1, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 100, 11, 103, 3500, 3800, 0.5)

lathframe <- sf_create(sizes = sizevector, stagenames = stagevector, repstatus = repvector,
                       obsstatus = obsvector, matstatus = matvector, immstatus = immvector,
                       indataset = indataset, binhalfwidth = binvec, propstatus = propvector)

lathvert <- verticalize3(lathyrus, noyears = 4, firstyear = 1988, patchidcol = "SUBPLOT",
                         individcol = "GENET", blocksize = 9, juvcol = "Seedling1988",
                         size1col = "Volume88", repstr1col = "FCODE88",
                         fec1col = "Intactseed88", dead1col = "Dead1988",
                         nonobs1col = "Dormant1988", stageassign = lathframe,
                         stagesize = "sizea", censorcol = "Missing1988",
                         censorkeep = NA, censor = TRUE)
summary(lathvert)

}
