% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datamanag.R
\name{verticalize3}
\alias{verticalize3}
\title{Create Historical Vertical Data Frame from Horizontal Data Frame}
\usage{
verticalize3(
  data,
  noyears,
  firstyear = 1,
  popidcol = 0,
  patchidcol = 0,
  individcol = 0,
  blocksize = NA,
  xcol = 0,
  ycol = 0,
  juvcol = 0,
  sizeacol,
  sizebcol = 0,
  sizeccol = 0,
  repstracol = 0,
  repstrbcol = 0,
  fecacol = 0,
  fecbcol = 0,
  indcovacol = 0,
  indcovbcol = 0,
  indcovccol = 0,
  aliveacol = 0,
  deadacol = 0,
  obsacol = 0,
  nonobsacol = 0,
  censorcol = 0,
  repstrrel = 1,
  fecrel = 1,
  stagecol = 0,
  stageassign = NA,
  stagesize = NA,
  censorkeep = 0,
  censorRepeat = FALSE,
  censor = FALSE,
  coordsRepeat = FALSE,
  spacing = NA,
  NAas0 = FALSE,
  NRasRep = FALSE,
  NOasObs = FALSE,
  reduce = TRUE,
  a2check = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{data}{The horizontal data file. A valid data frame is required as
input.}

\item{noyears}{The number of years or observation occasions in the dataset. A
valid integer is required as input.}

\item{firstyear}{The first year or occasion of observation. Defaults to
\code{1}.}

\item{popidcol}{A variable name or column number corresponding to the 
identity of the population for each individual.}

\item{patchidcol}{A variable name or column number corresponding to the 
identity of the patch or subpopulation for each individual, if patches have
been designated within populations.}

\item{individcol}{A variable name or column number corresponding to the 
identity of each individual.}

\item{blocksize}{The number of variables corresponding to each occasion in
the input dataset designated in \code{data}, if a set pattern of variables is
used for each observation occasion in the data frame used as input. If such a
pattern is not used, and all variable names are properly noted as character
vectors in the other input variables, then this may be set to \code{NA}.
Defaults to \code{NA}.}

\item{xcol}{A variable name(s) or column number(s) corresponding to the X 
coordinate of each individual, or of each individual at each occasion, in
Cartesian space. Can refer to the only instance, the first instance, or all
instances of X variables. In the last case, the values should be entered as a
vector.}

\item{ycol}{A variable name(s) or column number(s) corresponding to the Y
coordinate of each individual, or of each individual at each occasion, in
Cartesian space. Can refer to the only instance, the first instance, or all
instances of Y variables. In the last case, the values should be entered as a
vector.}

\item{juvcol}{A variable name(s) or column number(s) that marks individuals
in immature stages within the dataset. This function assumes that immature
individuals are identified in this variable marked with a number equal to or
greater than \code{1}, and that mature individuals are marked as \code{0} or
\code{NA}. Can refer to the first instance, or all instances of these
variables. In the latter case, the values should be entered as a vector.}

\item{sizeacol}{A variable name(s) or column number(s) corresponding to the
size entry associated with the first year or observation occasion in the
dataset. Can refer to the first instance, or all instances of these
variables. In the latter case, the values should be entered as a vector.
This variable should refer to the first size variable in the stageframe,
unless \code{stagesize = "sizeadded"}.}

\item{sizebcol}{A second variable name(s) or column number(s) corresponding
to the size entry associated with the first year or observation occasion in
the dataset. Can refer to the first instance, or all instances of these
variables. In the latter case, the values should be entered as a vector.
This variable should refer to the second size variable in the stageframe,
unless \code{stagesize = "sizeadded"}.}

\item{sizeccol}{A third variable name(s) or column number(s) corresponding to
the size entry associated with the first year or observation occasion in the
dataset. Can refer to the first instance, or all instances of these variables.
In the latter case, the values should be entered as a vector. This variable
should refer to the third size variable in the stageframe, unless
\code{stagesize = "sizeadded"}.}

\item{repstracol}{A variable name(s) or column number(s) corresponding to the
production of reproductive structures, such as flowers, associated with the 
first year or observation period in the input dataset. This can be binomial 
or count data, and is used to analyze the probability of reproduction. Can
refer to the first instance, or all instances of these variables. In the
latter case, the values should be entered as a vector.}

\item{repstrbcol}{A second variable name(s) or column number(s) corresponding
to the production of reproductive structures, such as flowers, associated
with the first year or observation period in the input dataset. This can be 
binomial or count data, and is used to analyze the probability of
reproduction. Can refer to the first instance, or all instances of these
variables. In the latter case, the values should be entered as a vector.}

\item{fecacol}{A variable name(s) or column number(s) denoting fecundity
associated with the first year or observation occasion in the input dataset.
This may represent egg counts, fruit counts, seed production, etc. Can refer
to the first instance, or all instances of these variables. In the latter
case, the values should be entered as a vector.}

\item{fecbcol}{A second variable name(s) or column number(s) denoting
fecundity associated with the first year or observation occasion in the input
dataset. This may represent egg counts, fruit counts, seed production, etc.
Can refer to the first instance, or all instances of these variables. In the
latter case, the values should be entered as a vector.}

\item{indcovacol}{A variable name(s) or column number(s) corresponding to an
individual covariate to be used in analysis. Can refer to the only instance,
the first instance, or all instances of these variables. In the last case,
the values should be entered as a vector.}

\item{indcovbcol}{A variable name(s) or column number(s) corresponding to an
individual covariate to be used in analysis. Can refer to the only instance,
the first instance, or all instances of these variables. In the last case,
the values should be entered as a vector.}

\item{indcovccol}{A second variable name(s) or column number(s) corresponding
to an individual covariate to be used in analysis. Can refer to the only
instance, the first instance, or all instances of these variables. In the
last case, the values should be entered as a vector.}

\item{aliveacol}{Variable name(s) or column number(s) providing information
on whether an individual is alive at a given occasion. If used, living status
must be designated as binomial (living = \code{1}, dead = \code{0}). Can
refer to the first instance of a living status variable in the dataset, or
a full vector of all living status variables in temporal order.}

\item{deadacol}{Variable name(s) or column number(s) providing information on
whether an individual is alive at a given occasion. If used, dead status must
be designated as binomial (dead = \code{1}, living = \code{0}).  Can refer to
the first instance of a dead status variable in the dataset, or a full vector
of all dead status variables in temporal order.}

\item{obsacol}{A variable name(s) or column number(s) providing information
on whether an individual is in an observable stage at a given occasion. If
used, observation status must be designated as binomial (observed = \code{1}, 
not observed = \code{0}). Can refer to the first instance of an observation
status variable in the dataset, or a full vector of all observation status
variables in temporal order.}

\item{nonobsacol}{A variable name(s) or column number(s) providing
information on whether an individual is in an unobservable stage at a given
occasion. If used, observation status must be designated as binomial (not
observed = \code{1}, observed = \code{0}). Can refer to the first instance of
a non-observation status variable in the dataset, or a full vector of all
non-observation status variables in temporal order.}

\item{censorcol}{A variable name(s) or column number(s) corresponding to the
first entry of a censor variable, used to distinguish between entries to use
and entries not to use, or to designate entries with special issues that
require further attention. Can refer to the first instance of a censor status
variable in the dataset, or a full vector of all censor status variables in
temporal order. Can also refer to a single censor status variable used for
the entire individual, if \code{singlecensor = TRUE}.}

\item{repstrrel}{This is a scalar multiplier on variable \code{repstrbcol} to
make it equivalent to \code{repstracol}. This can be useful if two 
reproductive status variables have related but unequal units, for example if
\code{repstracol} refers to one-flowered stems while \code{repstrbcol} refers
to two-flowered stems. Defaults to \code{1}.}

\item{fecrel}{This is a scalar multiplier on variable \code{fecbcol} to make
it equivalent to \code{fecacol}. This can be useful if two fecundity 
variables have related but unequal units. Defaults to \code{1}.}

\item{stagecol}{Optional variable name(s) or column number(s) corresponding
to life history stage at a given occasion. Can refer to the first instance of
a stage identity variable in the dataset, or a full vector of all stage
identity variables in temporal order.}

\item{stageassign}{The stageframe object identifying the life history model
being operationalized. Note that if \code{stagecol} is provided, then this
stageframe is not used for stage designation.}

\item{stagesize}{A variable name or column number describing which size 
variable to use in stage estimation. Defaults to NA, and can also take 
\code{sizea}, \code{sizeb}, \code{sizec}, \code{sizeab}, \code{sizebc},
\code{sizeac}, \code{sizeabc}, or \code{sizeadded}, depending on
which size variable within the input dataset is chosen. Note that the
variable(s) chosen should be presented in the order of the primary,
secondary, and tertiary variables in the stageframe input with
\code{stageassign}. For example, choosing \code{sizeb} assumes that this size
is the primary variable in the stageframe.}

\item{censorkeep}{The value of the censor variable identifying data to be
included in analysis. Defaults to \code{0}, but may take any value including
\code{NA}. Note that if \code{NA} is the value to keep, then this function
will alter all \code{NA}s to \code{0} values, and all other values to
\code{1}, treating \code{0} as the new value to keep.}

\item{censorRepeat}{A logical value indicating whether the censor variable
is a single column, or whether it repeats across occasion blocks. Defaults to
\code{FALSE}.}

\item{censor}{A logical variable determining whether the output data should 
be censored using the variable defined in \code{censorcol}. Defaults to 
\code{FALSE}.}

\item{coordsRepeat}{A logical value indicating whether X and Y coordinates
correspond to single X and Y columns. If \code{TRUE}, then each observation
occasion has its own X and Y variables. Defaults to \code{FALSE}.}

\item{spacing}{The spacing at which density should be estimated, if density
estimation is desired and X and Y coordinates are supplied. Given in the same
units as those used in the X and Y coordinates given in \code{xcol} and 
\code{ycol}. Defaults to \code{NA}.}

\item{NAas0}{If \code{TRUE}, then all \code{NA} entries for size and
fecundity variables will be set to 0. This can help increase the sample size
analyzed by \code{\link{modelsearch}()}, but should only be used when it is
clear that this substitution is biologically realistic. Defaults to
\code{FALSE}.}

\item{NRasRep}{If \code{TRUE}, then will treat non-reproductive but mature 
individuals as reproductive during stage assignment. This can be useful when
a MPM is desired without separation of reproductive and non-reproductive but
mature stages of the same size. Only used if \code{stageassign} is set to a
stageframe. Defaults to \code{FALSE}.}

\item{NOasObs}{If \code{TRUE}, then will treat individuals that are
interpreted as not observed in the dataset as though they were observed
during stage assignment. This can be useful when a MPM is desired without
separation of observable and unobservable stages. Only used if
\code{stageassign} is set to a stageframe. Defaults to \code{FALSE}.}

\item{reduce}{A logical variable determining whether unused variables and 
some invariant state variables should be removed from the output dataset.
Defaults to \code{TRUE}.}

\item{a2check}{A logical variable indicating whether to retain all data with
living status at occasion \emph{t} equal to 0. Defaults to \code{FALSE}, and
should be kept \code{FALSE} except to inspect potential errors in the
dataset.}

\item{quiet}{A logical variable indicating whether to silence warnings.
Defaults to \code{FALSE}.}
}
\value{
If all inputs are properly formatted, then this function will output
a historical vertical data frame (class \code{hfvdata}), meaning that the
output data frame will have three consecutive occasions of size and
reproductive data per individual per row. This data frame is in standard
format for all functions used in \code{lefko3}, and so can be used without
further modification.

Variables in this data frame include the following:
\item{rowid}{Unique identifier for the row of the data frame.}
\item{popid}{Unique identifier for the population, if given.}
\item{patchid}{Unique identifier for patch within population, if given.}
\item{individ}{Unique identifier for the individual.}
\item{year2}{Year or time at occasion \emph{t}.}
\item{firstseen}{Occasion of first observation.}
\item{lastseen}{Occasion of last observation.}
\item{obsage}{Observed age in occasion \emph{t}, assuming first observation
corresponds to age = 0.}
\item{obslifespan}{Observed lifespan, given as \code{lastseen - firstseen + 1}.}
\item{xpos1,xpos2,xpos3}{X position in Cartesian space in occasions
\emph{t}-1, \emph{t}, and \emph{t}+1, respectively, if provided.}
\item{ypos1,ypos2,ypos3}{Y position in Cartesian space in occasions
\emph{t}-1, \emph{t}, and \emph{t}+1, respectively, if provided.}
\item{sizea1,sizea2,sizea3}{Main size measurement in occasions \emph{t}-1, 
\emph{t}, and \emph{t}+1, respectively.}
\item{sizeb1,sizeb2,sizeb3}{Secondary size measurement in occasions
\emph{t}-1, \emph{t}, and \emph{t}+1, respectively.}
\item{sizec1,sizec2,sizec3}{Tertiary measurement in occasions \emph{t}-1, 
\emph{t}, and \emph{t}+1, respectively.}
\item{size1added,size2added,size3added}{Sum of primary, secondary, and 
tertiary size measurements in occasions \emph{t}-1, \emph{t}, and \emph{t}+1, 
respectively.}
\item{repstra1,repstra2,repstra3}{Main numbers of reproductive structures in
occasions \emph{t}-1, \emph{t}, and \emph{t}+1, respectively.}
\item{repstrb1,repstrb2,repstrb3}{Secondary numbers of reproductive 
structures in occasions \emph{t}-1, \emph{t}, and \emph{t}+1, respectively.}
\item{repstr1added,repstr2added,repstr3added}{Sum of primary and secondary
reproductive structures in occasions \emph{t}-1, \emph{t}, and \emph{t}+1, 
respectively.}
\item{feca1,feca2,feca3}{Main numbers of offspring in occasions \emph{t}-1, 
\emph{t}, and \emph{t}+1, respectively.}
\item{fecb1,fecb2, fecb3}{Secondary numbers of offspring in occasions
\emph{t}-1, \emph{t}, and \emph{t}+1, respectively.}
\item{fec1added,fec2added,fec3added}{Sum of primary and secondary fecundity
in occasions \emph{t}-1, \emph{t}, and \emph{t}+1, respectively.}
\item{censor1,censor2,censor3}{Censor state values in occasions \emph{t}-1, 
\emph{t}, and \emph{t}+1, respectively.}
\item{juvgiven1,juvgiven2,juvgiven3}{Binomial variable indicating whether
individual is juvenile in occasions \emph{t}-1, \emph{t}, and \emph{t}+1.
Only given if \code{juvcol} is provided.}
\item{obsstatus1,obsstatus2,obsstatus3}{Binomial observation state in
occasions \emph{t}-1, \emph{t}, and \emph{t}+1, respectively.}
\item{repstatus1,repstatus2,repstatus3}{Binomial reproductive state in
occasions \emph{t}-1, \emph{t}, and \emph{t}+1, respectively.}
\item{fecstatus1,fecstatus2,fecstatus3}{Binomial offspring production state
in occasions \emph{t}-1, \emph{t}, and \emph{t}+1, respectively.}
\item{matstatus1,matstatus2,matstatus3}{Binomial maturity state in occasions
\emph{t}-1, \emph{t}, and \emph{t}+1, respectively.}
\item{alive1,alive2,alive3}{Binomial state as alive in occasions \emph{t}-1,
 \emph{t}, and \emph{t}+1, respectively.}
\item{density}{Radial density of individuals per unit designated in
\code{spacing}. Only given if \code{spacing} is not NA.}
}
\description{
Function \code{verticalize3()} returns a vertically formatted demographic
data frame organized to create historical projection matrices, given a
horizontally formatted input data frame. It also handles stage assignments
if given an appropriate stageframe.
}
\section{Notes}{

In some datasets on species with unobserveable stages, observation status
(\code{obsstatus}) might not be inferred properly if a single size variable
is used that does not yield sizes greater than 0 in all cases in which
individuals were observed. Such situations may arise, for example, in plants
when leaf number is the dominant size variable used, but individuals
occasionally occur with inflorescences but no leaves. In this instances,
it helps to mark related variables as \code{sizeb} and \code{sizec}, because
observation status will be interpreted in relation to all 3 size variables.
Further analysis can then utilize only a single size variable, of the user's
choosing. Similar issues can arise in reproductive status (\code{repstatus}).

Juvenile designation should only be used when juveniles fall outside of the
size classification scheme used in determining stages. If juveniles are to be
size classified along the size spectrum that adults also fall on, then
it is best to treat juveniles as mature but not reproductive.

Warnings that some individuals occur in state combinations that do not match
any stages in the stageframe used to assign stages are common when first
working with a dataset. Typically, these situations can be identified as
\code{NoMatch} entries in \code{stage3}, although such entries may crop up in
\code{stage1} and \code{stage2}, as well. In rare cases, these warnings will
arise with no concurrent \code{NoMatch} entries, which indicates that the
input dataset contained conflicting state data at once suggesting that the
individual is in some stage but is also dead. The latter is removed if the
conflict occurs in occasion \emph{t} or \emph{t}-1, as only living entries
are allowed in time \emph{t} and time \emph{t}-1 may involve living entries
as well as unliving entries immediately prior to birth.

Care should be taken to avoid variables with negative values indicating size,
fecundity, or reproductive or observation status. Negative values can be
interpreted in different ways, typically reflecting estimation through other
algorithms rather than actual measured data. Variables holding negative
values can conflict with data management algorithms in ways that are
difficult to predict.

Unusual errors (e.g. \code{"Error in .pfj..."}) may occur in cases where the
variables are improperly passed, where seemingly numeric variables include
text, or where the \code{blocksize} is improperly set.

Density estimation is performed as a count of individuals alive and within
the radius specified in \code{spacing} of the respective individual at some
point in time.
}

\examples{
# Lathyrus example using blocksize - when repeated patterns exist in variable
# order
data(lathyrus)

sizevector <- c(0, 100, 13, 127, 3730, 3800, 0)
stagevector <- c("Sd", "Sdl", "VSm", "Sm", "VLa", "Flo", "Dorm")
repvector <- c(0, 0, 0, 0, 0, 1, 0)
obsvector <- c(0, 1, 1, 1, 1, 1, 0)
matvector <- c(0, 0, 1, 1, 1, 1, 1)
immvector <- c(1, 1, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 100, 11, 103, 3500, 3800, 0.5)

lathframe <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  immstatus = immvector, indataset = indataset, binhalfwidth = binvec,
  propstatus = propvector)

lathvert <- verticalize3(lathyrus, noyears = 4, firstyear = 1988,
  patchidcol = "SUBPLOT", individcol = "GENET", blocksize = 9,
  juvcol = "Seedling1988", sizeacol = "Volume88", repstracol = "FCODE88",
  fecacol = "Intactseed88", deadacol = "Dead1988",
  nonobsacol = "Dormant1988", stageassign = lathframe, stagesize = "sizea",
  censorcol = "Missing1988", censorkeep = NA, censor = TRUE)

lathsupp3 <- supplemental(stage3 = c("Sd", "Sd", "Sdl", "Sdl", "Sd", "Sdl", "mat"),
  stage2 = c("Sd", "Sd", "Sd", "Sd", "rep", "rep", "Sdl"),
  stage1 = c("Sd", "rep", "Sd", "rep", "npr", "npr", "Sd"),
  eststage3 = c(NA, NA, NA, NA, NA, NA, "mat"),
  eststage2 = c(NA, NA, NA, NA, NA, NA, "Sdl"),
  eststage1 = c(NA, NA, NA, NA, NA, NA, "NotAlive"),
  givenrate = c(0.345, 0.345, 0.054, 0.054, NA, NA, NA),
  multiplier = c(NA, NA, NA, NA, 0.345, 0.054, NA),
  type = c(1, 1, 1, 1, 3, 3, 1), type_t12 = c(1, 2, 1, 2, 1, 1, 1),
  stageframe = lathframe, historical = TRUE)

ehrlen3 <- rlefko3(data = lathvert, stageframe = lathframe, year = "all", 
  stages = c("stage3", "stage2", "stage1"), supplement = lathsupp3,
  yearcol = "year2", indivcol = "individ")

ehrlen3mean <- lmean(ehrlen3)
ehrlen3mean$A[[1]]

# Lathyrus example without blocksize - when no repeated patterns exist in
# variable order and all variables names are specified
data(lathyrus)

sizevector <- c(0, 100, 13, 127, 3730, 3800, 0)
stagevector <- c("Sd", "Sdl", "VSm", "Sm", "VLa", "Flo", "Dorm")
repvector <- c(0, 0, 0, 0, 0, 1, 0)
obsvector <- c(0, 1, 1, 1, 1, 1, 0)
matvector <- c(0, 0, 1, 1, 1, 1, 1)
immvector <- c(1, 1, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 100, 11, 103, 3500, 3800, 0.5)

lathframe <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  immstatus = immvector, indataset = indataset, binhalfwidth = binvec,
  propstatus = propvector)

lathvert <- verticalize3(lathyrus, noyears = 4, firstyear = 1988,
  patchidcol = "SUBPLOT", individcol = "GENET",
  juvcol = c("Seedling1988", "Seedling1989", "Seedling1990", "Seedling1991"),
  sizeacol = c("Volume88", "Volume89", "Volume90", "Volume91"),
  repstracol = c("FCODE88", "FCODE89", "FCODE90", "FCODE91"),
  fecacol = c("Intactseed88", "Intactseed89", "Intactseed90", "Intactseed91"),
  deadacol = c("Dead1988", "Dead1989", "Dead1990", "Dead1991"),
  nonobsacol = c("Dormant1988", "Dormant1989", "Dormant1990", "Dormant1991"),
  censorcol = c("Missing1988", "Missing1989", "Missing1990", "Missing1991"), 
  stageassign = lathframe, stagesize = "sizea",
  censorkeep = NA, censor = TRUE)

lathsupp3 <- supplemental(stage3 = c("Sd", "Sd", "Sdl", "Sdl", "Sd", "Sdl", "mat"),
  stage2 = c("Sd", "Sd", "Sd", "Sd", "rep", "rep", "Sdl"),
  stage1 = c("Sd", "rep", "Sd", "rep", "npr", "npr", "Sd"),
  eststage3 = c(NA, NA, NA, NA, NA, NA, "mat"),
  eststage2 = c(NA, NA, NA, NA, NA, NA, "Sdl"),
  eststage1 = c(NA, NA, NA, NA, NA, NA, "NotAlive"),
  givenrate = c(0.345, 0.345, 0.054, 0.054, NA, NA, NA),
  multiplier = c(NA, NA, NA, NA, 0.345, 0.054, NA),
  type = c(1, 1, 1, 1, 3, 3, 1), type_t12 = c(1, 2, 1, 2, 1, 1, 1),
  stageframe = lathframe, historical = TRUE)

ehrlen3 <- rlefko3(data = lathvert, stageframe = lathframe, year = "all", 
  stages = c("stage3", "stage2", "stage1"), supplement = lathsupp3,
  yearcol = "year2", indivcol = "individ")

ehrlen3mean <- lmean(ehrlen3)
ehrlen3mean$A[[1]]

# Cypripedium example using blocksize
rm(list=ls(all=TRUE))

data(cypdata)

sizevector <- c(0, 0, 0, 0, 0, 0, 1, 2.5, 4.5, 8, 17.5)
stagevector <- c("SD", "P1", "P2", "P3", "SL", "D", "XSm", "Sm", "Md", "Lg",
  "XLg")
repvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
obsvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
immvector <- c(0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 0, 0, 0, 0, 0.5, 0.5, 1, 1, 2.5, 7)

cypframe_raw <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  propstatus = propvector, immstatus = immvector, indataset = indataset,
  binhalfwidth = binvec)

cypraw_v1 <- verticalize3(data = cypdata, noyears = 6, firstyear = 2004,
  patchidcol = "patch", individcol = "plantid", blocksize = 4,
  sizeacol = "Inf2.04", sizebcol = "Inf.04", sizeccol = "Veg.04",
  repstracol = "Inf.04", repstrbcol = "Inf2.04", fecacol = "Pod.04",
  stageassign = cypframe_raw, stagesize = "sizeadded", NAas0 = TRUE,
  NRasRep = TRUE)

cypsupp2r <- supplemental(stage3 = c("SD", "P1", "P2", "P3", "SL", "D", 
    "XSm", "Sm", "SD", "P1"),
  stage2 = c("SD", "SD", "P1", "P2", "P3", "SL", "SL", "SL", "rep",
    "rep"),
  eststage3 = c(NA, NA, NA, NA, NA, "D", "XSm", "Sm", NA, NA),
  eststage2 = c(NA, NA, NA, NA, NA, "XSm", "XSm", "XSm", NA, NA),
  givenrate = c(0.10, 0.20, 0.20, 0.20, 0.25, NA, NA, NA, NA, NA),
  multiplier = c(NA, NA, NA, NA, NA, NA, NA, NA, 0.5, 0.5),
  type =c(1, 1, 1, 1, 1, 1, 1, 1, 3, 3),
  stageframe = cypframe_raw, historical = FALSE)

cypmatrix2r <- rlefko2(data = cypraw_v1, stageframe = cypframe_raw, 
  year = "all", patch = "all", stages = c("stage3", "stage2", "stage1"),
  size = c("size3added", "size2added"), supplement = cypsupp2r,
  yearcol = "year2", patchcol = "patchid", indivcol = "individ")

cyp2mean <- lmean(cypmatrix2r)
cyp2mean

# Cypripedium example using partial repeat patterns with blocksize and part
# explicit variable name cast
data(cypdata)

sizevector <- c(0, 0, 0, 0, 0, 0, 1, 2.5, 4.5, 8, 17.5)
stagevector <- c("SD", "P1", "P2", "P3", "SL", "D", "XSm", "Sm", "Md", "Lg",
  "XLg")
repvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
obsvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
immvector <- c(0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 0, 0, 0, 0, 0.5, 0.5, 1, 1, 2.5, 7)

cypframe_raw <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  propstatus = propvector, immstatus = immvector, indataset = indataset,
  binhalfwidth = binvec)

cypraw_v1 <- verticalize3(data = cypdata, noyears = 6, firstyear = 2004,
  patchidcol = "patch", individcol = "plantid", blocksize = 4,
  sizeacol = "Inf2.04", sizebcol = "Inf.04", sizeccol = "Veg.04",
  repstracol = c("Inf.04", "Inf.05", "Inf.06", "Inf.07", "Inf.08", "Inf.09"),
  repstrbcol = c("Inf2.04", "Inf2.05", "Inf2.06", "Inf2.07", "Inf2.08", "Inf2.09"), 
  fecacol = "Pod.04", stageassign = cypframe_raw, stagesize = "sizeadded",
  NAas0 = TRUE, NRasRep = TRUE)

cypsupp2r <- supplemental(stage3 = c("SD", "P1", "P2", "P3", "SL", "D", 
    "XSm", "Sm", "SD", "P1"),
  stage2 = c("SD", "SD", "P1", "P2", "P3", "SL", "SL", "SL", "rep",
    "rep"),
  eststage3 = c(NA, NA, NA, NA, NA, "D", "XSm", "Sm", NA, NA),
  eststage2 = c(NA, NA, NA, NA, NA, "XSm", "XSm", "XSm", NA, NA),
  givenrate = c(0.10, 0.20, 0.20, 0.20, 0.25, NA, NA, NA, NA, NA),
  multiplier = c(NA, NA, NA, NA, NA, NA, NA, NA, 0.5, 0.5),
  type =c(1, 1, 1, 1, 1, 1, 1, 1, 3, 3),
  stageframe = cypframe_raw, historical = FALSE)

cypmatrix2r <- rlefko2(data = cypraw_v1, stageframe = cypframe_raw, 
  year = "all", patch = "all", stages = c("stage3", "stage2", "stage1"),
  size = c("size3added", "size2added"), supplement = cypsupp2r,
  yearcol = "year2", patchcol = "patchid", indivcol = "individ")

cyp2mean <- lmean(cypmatrix2r)
cyp2mean

}
