% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixcreation.R
\name{rlefko3}
\alias{rlefko3}
\title{Create Raw Historical Matrix Projection Model}
\usage{
rlefko3(
  data,
  stageframe,
  year = "all",
  pop = NA,
  patch = NA,
  censor = FALSE,
  stages = NA,
  alive = c("alive3", "alive2", "alive1"),
  size = c("sizea3", "sizea2", "sizea1"),
  sizeb = c(NA, NA, NA),
  sizec = c(NA, NA, NA),
  repst = c("repstatus3", "repstatus2", "repstatus1"),
  matst = c("matstatus3", "matstatus2", "matstatus1"),
  fec = c("feca3", "feca2", "feca1"),
  supplement = NULL,
  repmatrix = NULL,
  overwrite = NULL,
  yearcol = NA,
  popcol = NA,
  patchcol = NA,
  indivcol = NA,
  censorcol = NA,
  censorkeep = 0,
  format = "ehrlen",
  reduce = FALSE,
  err_check = FALSE
)
}
\arguments{
\item{data}{A vertical demographic data frame, with variables corresponding 
to the naming conventions in \code{\link{verticalize3}()} and
\code{\link{historicalize3}()}.}

\item{stageframe}{A stageframe object that includes information on the size,
observation status, propagule status, reproduction status, immaturity status,
and maturity status of each ahistorical stage.}

\item{year}{A variable corresponding to observation occasion, or a set of
such values, given in values associated with the \code{year} term used in
vital rate model development. Can also equal \code{"all"}, in which case
matrices will be estimated for all occasions. Defaults to \code{"all"}.}

\item{pop}{A variable designating which populations will have matrices
estimated. Should be set to specific population names, or to \code{"all"} if
all populations should have matrices estimated.}

\item{patch}{A variable designating which patches or subpopulations will have
matrices estimated. Should be set to specific patch names, or to \code{"all"}
if matrices should be estimated for all patches. Defaults to \code{NA}, in
which case patch designations are ignored..}

\item{censor}{If \code{TRUE}, then data will be removed according to the
variable set in \code{censorcol}, such that only data with censor values
equal to \code{censorkeep} will remain. Defaults to \code{FALSE}.}

\item{stages}{An optional vector denoting the names of the variables within
the main vertical dataset coding for the stages of each individual in
occasions \emph{t}+1, \emph{t}, and \emph{t}-1. The names of stages in these
variables should match those used in the \code{stageframe} exactly. If left
blank, then \code{rlefko3()} will attempt to infer stages by matching values
of \code{alive}, \code{size}, \code{repst}, and \code{matst} to
characteristics noted in the associated \code{stageframe}.}

\item{alive}{A vector of names of binomial variables corresponding to status
as alive (\code{1}) or dead (\code{0}) in occasions \emph{t}+1, \emph{t}, and
\emph{t}-1, respectively.}

\item{size}{A vector of names of variables coding the primary size variable
in occasions \emph{t}+1, \emph{t}, and \emph{t}-1, respectively. Defaults to 
\code{c("sizea3", "sizea2", "sizea1")}.}

\item{sizeb}{A vector of names of variables coding the secondary size
variable in occasions \emph{t}+1, \emph{t}, and \emph{t}-1, respectively.
Defaults to \code{c(NA, NA, NA)}.}

\item{sizec}{A vector of names of variables coding the tertiary size
variable in occasions \emph{t}+1, \emph{t}, and \emph{t}-1, respectively.
Defaults to \code{c(NA, NA, NA)}.}

\item{repst}{A vector of names of variables coding reproductive status in
occasions \emph{t}+1, \emph{t}, and \emph{t}-1, respectively. Defaults to 
\code{c("repstatus3", "repstatus2", "repstatus1")}. Must be supplied if
\code{stages} is not provided.}

\item{matst}{A vector of names of variables coding maturity status in
occasions \emph{t}+1, \emph{t}, and \emph{t}-1, respectively. Defaults to
\code{c("matstatus3", "matstatus2", "matstatus1")}. Must be supplied if
\code{stages} is not provided.}

\item{fec}{A vector of names of variables coding fecundity in occasions
\emph{t}+1, \emph{t}, and \emph{t}-1, respectively. Defaults to
\code{c("feca3", "feca2", "feca1")}.}

\item{supplement}{An optional data frame of class \code{lefkoSD} that
provides supplemental data that should be incorporated into the MPM. Three
kinds of data may be integrated this way: transitions to be estimated via the
use of proxy transitions, transition overwrites from the literature or
supplemental studies, and transition multipliers for fecundity. This data
frame should be produced using the \code{\link{supplemental}()} function.
Should be used in place of or in addition to an overwrite table (see 
\code{overwrite} below) and a reproduction matrix (see \code{repmatrix}
below).}

\item{repmatrix}{An optional reproduction matrix. This matrix is composed
mostly of 0s, with non-zero entries acting as element identifiers and
multipliers for fecundity (with 1 equaling full fecundity). If left blank,
and no \code{supplement} is provided, then \code{rlefko3()} will assume that
all stages marked as reproductive produce offspring at 1x that of estimated
fecundity, and that offspring production will yield the first stage noted as
propagule or immature. To prevent this behavior, input just \code{0}, which
will result in fecundity being estimated only for transitions noted in
\code{supplement} above. May be the dimensions of either a historical or an
ahistorical matrix. If the latter, then all stages will be used in occasion
\emph{t}-1 for each suggested ahistorical transition.}

\item{overwrite}{An optional data frame developed with the
\code{\link{overwrite}()} function describing transitions to be overwritten
either with given values or with other estimated transitions. Note that this
function supplements overwrite data provided in \code{supplement}.}

\item{yearcol}{The variable name or column number corresponding to occasion
\emph{t} in the dataset.}

\item{popcol}{The variable name or column number corresponding to the
identity of the population.}

\item{patchcol}{The variable name or column number corresponding to patch in 
the dataset.}

\item{indivcol}{The variable name or column number coding individual
identity.}

\item{censorcol}{The variable name or column number denoting the censor
status. Only needed if \code{censor = TRUE}.}

\item{censorkeep}{The value of the censor variable denoting data elements to
keep. Defaults to \code{0}.}

\item{format}{A string indicating whether to estimate matrices in
\code{ehrlen} format or \code{deVries} format. The latter adds one unborn
prior stage to account for the prior state of newborns. Defaults to
\code{ehrlen} format.}

\item{reduce}{A logical value denoting whether to remove historical stages
associated exclusively with zero transitions. These are removed only if the
respective row and column sums in ALL matrices estimated equal 0. Defaults to
\code{FALSE}.}

\item{err_check}{A logical value indicating whether to append extra
information used in matrix calculation within the output list. Used for
development debugging purposes. Defaults to \code{FALSE}.}
}
\value{
If all inputs are properly formatted, then this function will return
an object of class \code{lefkoMat}, which is a list that holds the matrix
projection model and all of its metadata. Its structure is a list with the
following elements:

\item{A}{A list of full projection matrices in order of sorted populations,
patches, and occasions. All matrices output in the \code{matrix} class.}
\item{U}{A list of survival transition matrices sorted as in \code{A}. All 
matrices output in the \code{matrix} class.}
\item{F}{A list of fecundity matrices sorted as in \code{A}. All matrices 
output in the \code{matrix} class.}
\item{hstages}{A data frame matrix showing the pairing of ahistorical stages
used to create historical stage pairs.}
\item{agestages}{A data frame showing age-stage pairs. In this function, it
is set to NA. Only used in output to function \code{aflefko2}().}
\item{ahstages}{A data frame detailing the characteristics of associated
ahistorical stages, in the form of a modified stageframe that includes
status as an entry stage through reproduction.}
\item{labels}{A data frame giving the population, patch, and year of each 
matrix in order.}
\item{matrixqc}{A short vector describing the number of non-zero elements in
\code{U} and \code{F} matrices, and the number of annual matrices.}
\item{dataqc}{A vector showing the numbers of individuals and rows in the
vertical dataset used as input.}
}
\description{
Function \code{rlefko3()} returns raw historical MPMs, including the
associated component transition and fecundity matrices, data frames
describing the ahistorical stages used and the historical paired stages, and
a data frame describing the population, patch, and occasion time associated
with each matrix.
}
\section{Notes}{

The default behavior of this function is to estimate fecundity with regards
to transitions specified via associated fecundity multipliers in either
\code{supplement} or \code{repmatrix}. If both of these fields are left
empty, then fecundity will be estimated at full for all transitions leading
from reproductive stages to immature and propagule stages. However, if a
\code{supplement} is provided and a \code{repmatrix} is not, or if
\code{repmatrix} is set to 0, then only fecundity transitions noted in the
supplement will be set to non-zero values. To use the default behavior of
setting all reproductive stages to reproduce at full fecundity into immature
and propagule stages but incorporate given or proxy survival transitions,
input those given and proxy transitions through the \code{overwrite} option.

The reproduction matrix (field \code{repmatrix}) may be supplied as either
historical or ahistorical. If provided as ahistorical, then \code{flefko3()}
will assume that all historical transitions involving stages noted for
occasions \emph{t} and \emph{t}+1 should be set to the respective fecundity
multipliers noted.

Users may at times wish to estimate MPMs using a dataset incorporating
multiple patches or subpopulations. Should the aim of analysis be a general
MPM that does not distinguish these patches or subpopulations, the
\code{patchcol} variable should be left to \code{NA}, which is the default.
Otherwise the variable identifying patch needs to be named.

Input options including multiple variable names must be entered in the order
of variables in occasion \emph{t}+1, \emph{t}, and \emph{t}-1. Rearranging
the order WILL lead to erroneous calculations, and may lead to
fatal errors.

Although this function is capable of assigning stages given an input
stageframe, it lacks the power of \code{\link{verticalize3}()} and
\code{\link{historicalize3}()} in this regard. Users are strongly
encouraged to use the latter two functions for stage assignment.
}

\examples{
# Lathyrus example
data(lathyrus)

sizevector <- c(0, 100, 13, 127, 3730, 3800, 0)
stagevector <- c("Sd", "Sdl", "VSm", "Sm", "VLa", "Flo", "Dorm")
repvector <- c(0, 0, 0, 0, 0, 1, 0)
obsvector <- c(0, 1, 1, 1, 1, 1, 0)
matvector <- c(0, 0, 1, 1, 1, 1, 1)
immvector <- c(1, 1, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 100, 11, 103, 3500, 3800, 0.5)

lathframe <- sf_create(sizes = sizevector, stagenames = stagevector, 
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector, 
  immstatus = immvector, indataset = indataset, binhalfwidth = binvec, 
  propstatus = propvector)

lathvert <- verticalize3(lathyrus, noyears = 4, firstyear = 1988, 
  patchidcol = "SUBPLOT", individcol = "GENET", blocksize = 9, 
  juvcol = "Seedling1988", sizeacol = "Volume88", repstracol = "FCODE88", 
  fecacol = "Intactseed88", deadacol = "Dead1988", nonobsacol = "Dormant1988", 
  stageassign = lathframe, stagesize = "sizea", censorcol = "Missing1988", 
  censorkeep = NA, censor = TRUE)

lathsupp3 <- supplemental(stage3 = c("Sd", "Sd", "Sdl", "Sdl", "Sd", "Sdl", "mat"),
  stage2 = c("Sd", "Sd", "Sd", "Sd", "rep", "rep", "Sdl"),
  stage1 = c("Sd", "rep", "Sd", "rep", "npr", "npr", "Sd"),
  eststage3 = c(NA, NA, NA, NA, NA, NA, "mat"),
  eststage2 = c(NA, NA, NA, NA, NA, NA, "Sdl"),
  eststage1 = c(NA, NA, NA, NA, NA, NA, "NotAlive"),
  givenrate = c(0.345, 0.345, 0.054, 0.054, NA, NA, NA),
  multiplier = c(NA, NA, NA, NA, 0.345, 0.054, NA),
  type = c(1, 1, 1, 1, 3, 3, 1), type_t12 = c(1, 2, 1, 2, 1, 1, 1),
  stageframe = lathframe, historical = TRUE)

ehrlen3 <- rlefko3(data = lathvert, stageframe = lathframe, year = "all", 
  stages = c("stage3", "stage2", "stage1"), supplement = lathsupp3,
  yearcol = "year2", indivcol = "individ")

summary(ehrlen3)

# Cypripedium example
data(cypdata)

sizevector <- c(0, 0, 0, 0, 0, 0, 1, 2.5, 4.5, 8, 17.5)
stagevector <- c("SD", "P1", "P2", "P3", "SL", "D", "XSm", "Sm", "Md", "Lg",
  "XLg")
repvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
obsvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
immvector <- c(0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 0, 0, 0, 0, 0.5, 0.5, 1, 1, 2.5, 7)

cypframe_raw <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  propstatus = propvector, immstatus = immvector, indataset = indataset,
  binhalfwidth = binvec)

cypraw_v1 <- verticalize3(data = cypdata, noyears = 6, firstyear = 2004,
  patchidcol = "patch", individcol = "plantid", blocksize = 4,
  sizeacol = "Inf2.04", sizebcol = "Inf.04", sizeccol = "Veg.04",
  repstracol = "Inf.04", repstrbcol = "Inf2.04", fecacol = "Pod.04",
  stageassign = cypframe_raw, stagesize = "sizeadded", NAas0 = TRUE,
  NRasRep = TRUE)

cypsupp3r <- supplemental(stage3 = c("SD", "SD", "P1", "P1", "P2", "P3", "SL",
    "D", "XSm", "Sm", "D", "XSm", "Sm", "mat", "mat", "mat", "SD", "P1"),
  stage2 = c("SD", "SD", "SD", "SD", "P1", "P2", "P3", "SL", "SL", "SL", "SL",
    "SL", "SL", "D", "XSm", "Sm", "rep", "rep"),
  stage1 = c("SD", "rep", "SD", "rep", "SD", "P1", "P2", "P3", "P3", "P3",
    "SL", "SL", "SL", "SL", "SL", "SL", "mat", "mat"),
  eststage3 = c(NA, NA, NA, NA, NA, NA, NA, "D", "XSm", "Sm", "D", "XSm", "Sm",
    "mat", "mat", "mat", NA, NA),
  eststage2 = c(NA, NA, NA, NA, NA, NA, NA, "XSm", "XSm", "XSm", "XSm", "XSm",
    "XSm", "D", "XSm", "Sm", NA, NA),
  eststage1 = c(NA, NA, NA, NA, NA, NA, NA, "XSm", "XSm", "XSm", "XSm", "XSm",
    "XSm", "XSm", "XSm", "XSm", NA, NA),
  givenrate = c(0.1, 0.1, 0.2, 0.2, 0.2, 0.2, 0.25, NA, NA, NA, NA, NA, NA,
    NA, NA, NA, NA, NA),
  multiplier = c(NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
    NA, 0.5, 0.5),
  type = c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3),
  type_t12 = c(1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1),
  stageframe = cypframe_raw, historical = TRUE)

cypmatrix3r <- rlefko3(data = cypraw_v1, stageframe = cypframe_raw,
  year = "all", patch = "all", stages = c("stage3", "stage2", "stage1"),
  size = c("size3added", "size2added", "size1added"),
  supplement = cypsupp3r, yearcol = "year2", patchcol = "patchid",
  indivcol = "individ")

summary(cypmatrix3r)

}
\seealso{
\code{\link{flefko3}()}

\code{\link{flefko2}()}

\code{\link{aflefko2}()}

\code{\link{arlefko2}()}

\code{\link{fleslie}()}

\code{\link{rlefko2}()}

\code{\link{rleslie}()}
}
