% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popchar.R
\name{start_input}
\alias{start_input}
\title{Create a Starting Vector for Population Projection}
\usage{
start_input(mpm, stage2, stage1 = NA, age2 = NA, value = 1)
}
\arguments{
\item{mpm}{The lefkoMat object to be used in projection analysis.}

\item{stage2}{A vector showing the name or number of a stage in occasion
\emph{t} that should be set to a positive number of individuals in the start
vector. Abbreviations for groups of stages are also usable (see Notes).
This input is required and has no default input.}

\item{stage1}{A vector showing the name or number of a stage in occasion
\emph{t}-1 that should be set to a positive number of individuals in the
start vector. Abbreviations for groups of stages are also usable (see Notes).
This is only used for historical MPMs, since the rows of hMPMs correspond to
stage-pairs in times \emph{t} and \emph{t}-1 together. Only required for
historical MPMs, and will result in errors if otherwise used.}

\item{age2}{A vector showing the age of each respective stage in occasion
\emph{t} that should be set to a positie number of individuals in the start
vector. Only used for age-by-stage MPMs. Defaults to NA.}

\item{value}{A vector showing the values, in order, of the number of
individuals set for the stage or stage-pair in question. Defaults to 1.}
}
\value{
A list of class \code{lefkoStart}, with 4 objects, which can be used
as input in function \code{\link{projection3}()}. The last three include the
\code{ahstages}, \code{hstages}, and \code{agestages} objects from the
\code{lefkoMat} object supplied in \code{mpm}. The first element in the list
is a data frame with the following variables:

\item{stage2}{Stage at occasion \emph{t}.}
\item{stage_id_2}{The stage number associated with \code{stage2}.}
\item{stage1}{Stage at occasion \emph{t}-1, if historical. Otherwise NA.}
\item{stage_id_1}{The stage number associated with \code{stage1}.}
\item{age2}{The age of individuals in \code{stage2} and, if applicable,
\code{stage1}. Only used in age-by-stage MPMs.}
\item{row_num}{A number indicating the respective starting vector element.}
\item{value}{Number of individuals in corresponding stage or stage-pair.}
}
\description{
Function \code{start_input()} creates a data frame summarizing the non-zero
elements of the start vector for use in population projection analysis via
function \code{\link{projection3}()}.
}
\section{Notes}{

Entries in \code{stage2}, and \code{stage1} can include abbreviations for
groups of stages. Use \code{rep} if all reproductive stages are to be used,
\code{nrep} if all mature but non-reproductive stages are to be used,
\code{mat} if all mature stages are to be used, \code{immat} if all immature
stages are to be used, \code{prop} if all propagule stages are to be used,
\code{npr} if all non-propagule stages are to be used, \code{obs} if all
observable stages are to be used, \code{nobs} if all unobservable stages are
to be used, and leave empty or use \code{all} if all stages in stageframe are
to be used.
}

\examples{
data(lathyrus)

sizevector <- c(0, 100, 13, 127, 3730, 3800, 0)
stagevector <- c("Sd", "Sdl", "VSm", "Sm", "VLa", "Flo", "Dorm")
repvector <- c(0, 0, 0, 0, 0, 1, 0)
obsvector <- c(0, 1, 1, 1, 1, 1, 0)
matvector <- c(0, 0, 1, 1, 1, 1, 1)
immvector <- c(1, 1, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 100, 11, 103, 3500, 3800, 0.5)

lathframe <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  immstatus = immvector, indataset = indataset, binhalfwidth = binvec,
  propstatus = propvector)

lathvert <- verticalize3(lathyrus, noyears = 4, firstyear = 1988,
  patchidcol = "SUBPLOT", individcol = "GENET", blocksize = 9,
  juvcol = "Seedling1988", sizeacol = "Volume88", repstracol = "FCODE88",
  fecacol = "Intactseed88", deadacol = "Dead1988",
  nonobsacol = "Dormant1988", stageassign = lathframe, stagesize = "sizea",
  censorcol = "Missing1988", censorkeep = NA, censor = TRUE)

lathsupp3 <- supplemental(stage3 = c("Sd", "Sd", "Sdl", "Sdl", "Sd", "Sdl", "mat"),
  stage2 = c("Sd", "Sd", "Sd", "Sd", "rep", "rep", "Sdl"),
  stage1 = c("Sd", "rep", "Sd", "rep", "npr", "npr", "Sd"),
  eststage3 = c(NA, NA, NA, NA, NA, NA, "mat"),
  eststage2 = c(NA, NA, NA, NA, NA, NA, "Sdl"),
  eststage1 = c(NA, NA, NA, NA, NA, NA, "NotAlive"),
  givenrate = c(0.345, 0.345, 0.054, 0.054, NA, NA, NA),
  multiplier = c(NA, NA, NA, NA, 0.345, 0.054, NA),
  type = c(1, 1, 1, 1, 3, 3, 1), type_t12 = c(1, 2, 1, 2, 1, 1, 1),
  stageframe = lathframe, historical = TRUE)

ehrlen3 <- rlefko3(data = lathvert, stageframe = lathframe, year = "all", 
  stages = c("stage3", "stage2", "stage1"), supplement = lathsupp3,
  yearcol = "year2", indivcol = "individ")

ehrlen3mean <- lmean(ehrlen3)

e3m_sv <- start_input(ehrlen3mean, stage2 = "Sd", stage1 = "Sd", value = 1000)

lathproj <- projection3(ehrlen3, nreps = 5, times = 100, stochastic = TRUE,
  start_frame = e3m_sv)

}
\seealso{
\code{\link{density_input}()}

\code{\link{projection3}()}
}
