% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{slambda3}
\alias{slambda3}
\title{Estimate Stochastic Population Growth Rate}
\usage{
slambda3(
  mpm,
  times = 10000L,
  historical = FALSE,
  tweights = NULL,
  force_sparse = NULL
)
}
\arguments{
\item{mpm}{A matrix projection model of class \code{lefkoMat}, or a list of
full matrix projection matrices.}

\item{times}{Number of occasions to iterate. Defaults to \code{10000}.}

\item{historical}{An optional logical value only used if object \code{mpm}
is a list of matrices, rather than a \code{lefkoMat} object. Defaults to
\code{FALSE} for the former case, and overridden by information supplied in
the \code{lefkoMat} object for the latter case.}

\item{tweights}{Numeric vector denoting the probabilistic weightings of
annual matrices. Defaults to equal weighting among occasions.}

\item{force_sparse}{A text string indicating whether to force sparse matrix 
encoding (\code{"yes"}) or not (\code{"no"}) if the MPM is composed of
simple matrices. Defaults to \code{"auto"}, in which case sparse matrix
encoding is used with simple square matrices with at least 50 rows and no
more than 50\% of elements with values greater than zero.}
}
\value{
A data frame with the following variables:
\item{pop}{The identity of the population.}
\item{patch}{The identity of the patch.}
\item{a}{Estimate of stochastic growth rate, estimated as the arithmetic
mean of the log population growth rate across simulated occasions.}
\item{var}{The estimated variance of a.}
\item{sd}{The standard deviation of a.}
\item{se}{The standard error of a.}
}
\description{
Function \code{slambda3()} estimates the stochastic population growth rate,
\eqn{a}, defined as the long-term arithmetic mean of the log population 
growth rate estimated per simulated occasion. This function can handle both
lefkoMat objects and lists of full A matrices as input.
}
\section{Notes}{

The log stochastic population growth rate, \eqn{a}, is as given in equation
2 of Tuljapurkar, Horvitz, and Pascarella 2003. This term is estimated via
projection of randomly sampled matrices, similarly to the procedure outlined
in Box 7.4 of Morris and Doak (2002).

Stochastic growth rate is estimated both at the patch level and at the
population level. Population level estimates will be noted at the end of the
data frame with 0 entries for patch designation.

Weightings given in \code{tweights} do not need to sum to 1. Final
weightings used will be based on the proportion per element of the sum of
elements in the user-supplied vector.

Speed can sometimes be increased by shifting from automatic sparse matrix
determination to forced dense or sparse matrix projection. This will most
likely occur when matrices have between 30 and 300 rows and columns.
Defaults work best when matrices are very small and dense, or very large and
sparse.
}

\examples{
data(cypdata)

sizevector <- c(0, 0, 0, 0, 0, 0, 1, 2.5, 4.5, 8, 17.5)
stagevector <- c("SD", "P1", "P2", "P3", "SL", "D", "XSm", "Sm", "Md", "Lg",
  "XLg")
repvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
obsvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
immvector <- c(0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 0, 0, 0, 0, 0.5, 0.5, 1, 1, 2.5, 7)

cypframe_raw <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector, 
  propstatus = propvector, immstatus = immvector, indataset = indataset,
  binhalfwidth = binvec)

cypraw_v1 <- verticalize3(data = cypdata, noyears = 6, firstyear = 2004,
  patchidcol = "patch", individcol = "plantid", blocksize = 4, 
  sizeacol = "Inf2.04", sizebcol = "Inf.04", sizeccol = "Veg.04", 
  repstracol = "Inf.04", repstrbcol = "Inf2.04", fecacol = "Pod.04",
  stageassign = cypframe_raw, stagesize = "sizeadded", NAas0 = TRUE, 
  NRasRep = TRUE)

cypsupp3r <- supplemental(stage3 = c("SD", "SD", "P1", "P1", "P2", "P3", "SL",
    "D", "XSm", "Sm", "D", "XSm", "Sm", "mat", "mat", "mat", "SD", "P1"),
  stage2 = c("SD", "SD", "SD", "SD", "P1", "P2", "P3", "SL", "SL", "SL", "SL",
    "SL", "SL", "D", "XSm", "Sm", "rep", "rep"),
  stage1 = c("SD", "rep", "SD", "rep", "SD", "P1", "P2", "P3", "P3", "P3",
    "SL", "SL", "SL", "SL", "SL", "SL", "mat", "mat"),
  eststage3 = c(NA, NA, NA, NA, NA, NA, NA, "D", "XSm", "Sm", "D", "XSm", "Sm",
    "mat", "mat", "mat", NA, NA),
  eststage2 = c(NA, NA, NA, NA, NA, NA, NA, "XSm", "XSm", "XSm", "XSm", "XSm",
    "XSm", "D", "XSm", "Sm", NA, NA),
  eststage1 = c(NA, NA, NA, NA, NA, NA, NA, "XSm", "XSm", "XSm", "XSm", "XSm",
    "XSm", "XSm", "XSm", "XSm", NA, NA),
  givenrate = c(0.1, 0.1, 0.2, 0.2, 0.2, 0.2, 0.25, NA, NA, NA, NA, NA, NA,
    NA, NA, NA, NA, NA),
  multiplier = c(NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
    NA, 0.5, 0.5),
  type = c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3),
  type_t12 = c(1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1),
  stageframe = cypframe_raw, historical = TRUE)

cypmatrix3r <- rlefko3(data = cypraw_v1, stageframe = cypframe_raw, 
  year = "all", patch = "all", stages = c("stage3", "stage2", "stage1"),
  size = c("size3added", "size2added", "size1added"), 
  supplement = cypsupp3r, yearcol = "year2", 
  patchcol = "patchid", indivcol = "individ")

cypstoch <- slambda3(cypmatrix3r)

}
