% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_voting_record.R
\name{search_voting_record}
\alias{search_voting_record}
\alias{legco_search_voting_record}
\title{Search Voting Record}
\usage{
search_voting_record(
  speaker_id = NULL,
  member_id = NULL,
  committee_id = NULL,
  slot_id = NULL,
  from = "1900-01-01 00:00:00",
  to = Sys.time(),
  verbose = TRUE,
  ...
)

legco_search_voting_record(
  speaker_id = NULL,
  member_id = NULL,
  committee_id = NULL,
  slot_id = NULL,
  from = "1900-01-01 00:00:00",
  to = Sys.time(),
  verbose = TRUE,
  ...
)
}
\arguments{
\item{speaker_id}{the id of a speaker at the Legislative Council, or a vector
of ids. If \code{NULL}, returns all speakers. Defaults to \code{NULL}.}

\item{member_id}{the id of a LegCo member, or a vector of ids. If
\code{NULL}, returns results of all LegCo members. Defaults to \code{NULL}.}

\item{committee_id}{the id of a committee, or a vector of ids. If
\code{NULL}, returns results of all committees. Defaults to \code{NULL}.}

\item{slot_id}{the id of a meeting slot, or a vector of ids. If \code{NULL},
returns all meetings. Defaults to \code{NULL}.}

\item{from}{only fetch results of meetings on or after this date and time.
Accepts character values in \code{"YYYY-MM-DD"} or \code{"YYYY-MM-DD
HH:MM:SS"} format, and objects of class \code{Date}, \code{POSIXt},
\code{POSIXct}, \code{POSIXlt} or anything else that can be coerced to a
date with \code{as.Date()}. Defaults to \code{"1900-01-01 00:00:00"}.}

\item{to}{only fetch results of meetings on or before this date and time.
Accepts character values in \code{"YYYY-MM-DD"} or \code{"YYYY-MM-DD
HH:MM:SS"} format, and objects of class \code{Date}, \code{POSIXt},
\code{POSIXct}, \code{POSIXlt} or anything else that can be coerced to a
date with \code{as.Date()}. Defaults to the current system time.}

\item{verbose}{logical: Whether to display progress messages when fetching
data? Defaults to \code{TRUE}.}

\item{...}{optional arguments passed to \code{\link{voting_record}()}.}
}
\description{
Search voting record by conducted committee or date or meeting slot or LegCo
member(s). Note that only voting records from the Council, House Committee,
Finance Committee and its subcommittees are available.
}
\details{
This is a complementary function to \code{\link{voting_record}()}.
}
\section{Functions}{
 Complementary Functions: \itemize{ \item
  \code{\link{search_committee}}: Search LegCo committees \item
  \code{\link{search_member}}: Search LegCo members \item
  \code{\link{search_voting_record}}: Search Voting Record in LegCo meetings
  \item \code{\link{search_question}}: Search full text of question put to
  the government by LegCo members}
}

\section{Notes}{
 The complementary functions work by calling a number of
  database functions and combining their output, meaning that a function call
  usually involves multiple API calls. Use with caution to prevent reaching
  the API’s rate limit too quickly.
}

