% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{theme_guide}
\alias{theme_guide}
\title{Theme wrapper for guides}
\usage{
theme_guide(
  text = NULL,
  line = NULL,
  title = NULL,
  subtitle = NULL,
  text.position = NULL,
  title.position = NULL,
  subtitle.position = NULL,
  ticks = NULL,
  minor.ticks = NULL,
  mini.ticks = NULL,
  ticks.length = NULL,
  minor.ticks.length = NULL,
  mini.ticks.length = NULL,
  spacing = NULL,
  group.spacing = NULL,
  key = NULL,
  key.size = NULL,
  key.width = NULL,
  key.height = NULL,
  key.spacing = NULL,
  key.spacing.x = NULL,
  key.spacing.y = NULL,
  key.margin = NULL,
  frame = NULL,
  byrow = NULL,
  background = NULL,
  margin = NULL,
  bracket = NULL,
  bracket.size = NULL,
  box = NULL,
  fence = NULL,
  fence.post = NULL,
  fence.rail = NULL
)
}
\arguments{
\item{text}{An \code{\link[ggplot2:element]{<element_text>}} setting both
\code{legend.text} and \code{axis.text} elements.}

\item{line}{An \code{\link[ggplot2:element]{<element_line>}} setting both
\code{legend.axis.line} and \code{axis.line} elements.}

\item{title}{An \code{\link[ggplot2:element]{<element_text>}} setting both
\code{legend.title} and \code{axis.title} elements.}

\item{subtitle}{An \code{\link[ggplot2:element]{<element_text>}} setting both
\code{legendry.legend.subtitle} and \code{legendry.axis.subtitle} elements.}

\item{text.position, title.position, subtitle.position}{One of \code{"top"},
\code{"right"}, \code{"bottom"} or \code{"right"} setting the following elements:
\itemize{
\item \code{text.position}: sets only \code{legend.text.position}.
\item \code{title.position}: sets only \code{legend.title.position}.
\item \code{subtitle.position} sets both \code{legendry.legend.subtitle.position} and
\code{legendry.axis.subtitle.position}
}}

\item{ticks}{An \code{\link[ggplot2:element]{<element_line>}} setting both
\code{axis.ticks} and \code{legend.ticks} elements.}

\item{minor.ticks}{An \code{\link[ggplot2:element]{<element_line>}} setting
\code{legendry.legend.minor.ticks} and all 6 of the
\verb{axis.ticks.minor.\{r/theta/x.top/x.bottom/y.left/y.right\}} elements.}

\item{mini.ticks}{An \code{\link[ggplot2:element]{<element_line>}} setting both
\code{legendry.legend.mini.ticks} and \code{legendry.axis.mini.ticks} elements.}

\item{ticks.length, minor.ticks.length, mini.ticks.length}{A
[\verb{<unit[1]>}][grid::unit()] setting the following elements:
\itemize{
\item \code{ticks.length}: sets both \code{legend.ticks.length} and \code{axis.ticks.length}.
\item \code{minor.ticks.length} sets both \code{axis.minor.ticks.length} and
\code{legendry.legend.minor.ticks.length}.
\item \code{mini.ticks.length} sets both \code{legendry.axis.mini.ticks.length} and
\code{legendry.legend.mini.ticks.length}.
}}

\item{spacing, group.spacing}{A [\verb{<unit[1]>}][grid::unit()] setting both the
\code{legendry.guide.spacing} and \code{legendry.group.spacing} theme elements.}

\item{key}{An \code{\link[ggplot2:element]{<element_rect>}} setting the
\code{legend.key} element.}

\item{key.size, key.width, key.height}{A \code{\link[grid:unit]{<unit>}} setting the
\code{legend.key.size}, \code{legend.key.width} and \code{legend.key.height} elements
respectively.}

\item{key.spacing, key.spacing.x, key.spacing.y}{A [\verb{<unit[1]>}][grid::unit()]
setting the \code{legend.key.spacing}, \code{legend.key.spacing.x} and
\code{legend.key.spacing.y} elements respectively.}

\item{key.margin}{A \code{\link[ggplot2:element]{<margin>}} setting the margin around
legend glyphs.}

\item{frame}{An \code{\link[ggplot2:element]{<element_rect>}} setting the
\code{legend.frame} element.}

\item{byrow}{A \verb{<logical[1]>} setting the \code{legend.byrow} element.}

\item{background}{An \code{\link[ggplot2:element]{<element_rect>}} setting the
\code{legend.background} element.}

\item{margin}{A \code{\link[ggplot2:element]{<margin>}} setting the \code{legend.margin}
element.}

\item{bracket}{An \code{\link[ggplot2:element]{<element_line>}} setting the
\code{legendry.bracket} element.}

\item{bracket.size}{A [\verb{<unit[1]>}][grid::unit()] setting the
\code{legendry.bracket.size} element.}

\item{box}{An \code{\link[ggplot2:element]{<element_rect>}} setting the
\code{legendry.box} element.}

\item{fence, fence.post, fence.rail}{An
\code{\link[ggplot2:element]{<element_line>}} setting the \code{legendry.fence},
\code{legendry.fence.post} and \code{legendry.fence.rail} respectively.}
}
\value{
A \verb{<theme>} object that can be provided to a guide.
}
\description{
This function has shorthand names for theme elements relating to guides. It
is intended to be used as the \code{guide_*(theme)} argument. Because of this
intent, and due to legends and axes having mutually exclusive theme elements,
this function sets the elements for both simultaneously.
}
\examples{
red_ticks <- theme_guide(ticks = element_line(colour = "red", linewidth = 0.5))

# Both axis and colourbar gain red ticks
ggplot(mpg, aes(displ, hwy, colour = cty)) +
  geom_point() +
  guides(
    colour = guide_colourbar(theme = red_ticks),
    x = guide_axis(theme = red_ticks)
  )
}
