## ---- include=FALSE---------------------------------------------------------------------------------------------------
knitr::opts_chunk$set(fig.width=4, fig.height=3.5)

## ----include=FALSE----------------------------------------------------------------------------------------------------
suppressPackageStartupMessages(library("lessR"))

## ---------------------------------------------------------------------------------------------------------------------
d <- Read("Employee")

## ---------------------------------------------------------------------------------------------------------------------
getColors("hues")

## ---------------------------------------------------------------------------------------------------------------------
getColors(in_order=TRUE)

## ---------------------------------------------------------------------------------------------------------------------
getColors(n=36, shape="wheel", border="off")

## ---------------------------------------------------------------------------------------------------------------------
BarChart(Dept, fill=getColors(c=90, l=45))

## ---------------------------------------------------------------------------------------------------------------------
#showPalettes()

## ---------------------------------------------------------------------------------------------------------------------
BarChart(Dept, fill=getColors("blues"))

## ---------------------------------------------------------------------------------------------------------------------
BarChart(Dept, fill=getColors("blues", c=60, l=c(30,80)))

## ---------------------------------------------------------------------------------------------------------------------
BarChart(Dept, fill=getColors("browns", c=c(20,90), l=60))

## ---- fig.width=6-----------------------------------------------------------------------------------------------------
d <- Read("StockPrice", quiet=TRUE)
Plot(date, Price, by=Company, trans=0.4, stack=TRUE, area_fill="reds")
d <- Read("Employee", quiet=TRUE)

## ---------------------------------------------------------------------------------------------------------------------
BarChart(Dept, fill=getColors("rusts", "blues"))

## ---------------------------------------------------------------------------------------------------------------------
BarChart(Dept, fill=getColors("rusts", "blues", c=45))

## ---------------------------------------------------------------------------------------------------------------------
BarChart(Dept, fill=getColors(c=90, l=45))

## ---------------------------------------------------------------------------------------------------------------------
getColors(c("black", "blue", "red"))

## ---------------------------------------------------------------------------------------------------------------------
getColors(pal="aliceblue", end_pal="blue")

## ---------------------------------------------------------------------------------------------------------------------
style("darkred")
BarChart(Dept)

## ---------------------------------------------------------------------------------------------------------------------
style()

## ---------------------------------------------------------------------------------------------------------------------
style(window_fill="aliceblue")
BarChart(Dept)

## ---------------------------------------------------------------------------------------------------------------------
style()

## ---------------------------------------------------------------------------------------------------------------------
style(show=TRUE)

