# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @name SEMCpp
#' 
#' @title SEMCpp class
#' 
#' @description internal SEM representation
#' 
#' @field new Creates a new SEMCpp.
#' @field fill fills the SEM with the elements from an Rcpp::List
#' @field addTransformation adds transforamtions to a model
#' @field implied Computes implied means and covariance matrix
#' @field fit Fits the model. Returns -2 log likelihood
#' @field getParameters Returns a data frame with model parameters.
#' @field getParameterLabels Returns a vector with unique parameter labels as used internally.
#' @field getGradients Returns a matrix with scores.
#' @field getScores Returns a matrix with scores.
#' @field getHessian Returns the hessian of the model. Expects the labels of the 
#' parameters and the values of the parameters as well as a boolean indicating if 
#' these are raw. Finally, a double (eps) controls the precision of the approximation.
#' @field computeTransformations compute the transformations.
#' @field setTransformationGradientStepSize change the step size of the gradient computation for the transformations
NULL

#' callFitFunction
#' 
#' wrapper to call user defined fit function
#' @param fitFunctionSEXP pointer to fit function
#' @param parameters vector with parameter values
#' @param userSuppliedElements list with additional elements
#' @returns fit value (double)
#' 
callFitFunction <- function(fitFunctionSEXP, parameters, userSuppliedElements) {
    .Call(`_lessSEM_callFitFunction`, fitFunctionSEXP, parameters, userSuppliedElements)
}

#'@name istaCappedL1SEM
#'@title cappedL1 optimization with ista
#'@description Object for elastic net optimization with
#'ista optimizer
#'@field new creates a new object. Requires (1) a vector with weights for each
#'parameter and (2) a list with control elements
#'@field optimize optimize the model. Expects a vector with starting values,
#'a SEM of type SEM_Cpp, a theta value, a lambda and an alpha value (alpha must be 1).
#'@returns a list with fit results
NULL

#'@name istaCappedL1mgSEM
#'@title cappedL1 optimization with ista
#'@description Object for elastic net optimization with
#'ista optimizer
#'@field new creates a new object. Requires (1) a vector with weights for each
#'parameter and (2) a list with control elements
#'@field optimize optimize the model. Expects a vector with starting values,
#'a SEM of type SEM_Cpp, a theta value, a lambda and an alpha value (alpha must be 1).
#'@returns a list with fit results
NULL

#'@name bfgsEnet
#'@title smoothly approximated elastic net
#'@description Object for smoothly approximated elastic net optimization with
#'bfgs optimizer
#'@field new creates a new object. Requires (1) a vector with weights for each
#'parameter and (2) a list with control elements
#'@field setHessian changes the Hessian of the model. Expects a matrix
#'@field optimize optimize the model. Expects a vector with starting values,
#'a SEM of type SEM_Cpp, a lambda and an alpha value.
#'@returns a list with fit results
#'
NULL

#'@name bfgsEnetSEM
#'@title smoothly approximated elastic net
#'@description Object for smoothly approximated elastic net optimization with
#'bfgs optimizer
#'@field new creates a new object. Requires (1) a vector with weights for each
#'parameter and (2) a list with control elements
#'@field setHessian changes the Hessian of the model. Expects a matrix
#'@field optimize optimize the model. Expects a vector with starting values,
#'a SEM of type SEM_Cpp, a lambda and an alpha value.
#'@returns a list with fit results
NULL

#'@name bfgsEnetMgSEM
#'@title smoothly approximated elastic net
#'@description Object for smoothly approximated elastic net optimization with
#'bfgs optimizer
#'@field new creates a new object. Requires (1) a vector with weights for each
#'parameter and (2) a list with control elements
#'@field setHessian changes the Hessian of the model. Expects a matrix
#'@field optimize optimize the model. Expects a vector with starting values,
#'a SEM of type SEM_Cpp, a lambda and an alpha value.
#'@returns a list with fit results
NULL

#'@name glmnetEnetSEM
#'@title elastic net optimization with glmnet optimizer
#'@description Object for elastic net optimization with
#'glmnet optimizer
#'@field new creates a new object. Requires (1) a vector with weights for each
#'parameter and (2) a list with control elements
#'@field setHessian changes the Hessian of the model. Expects a matrix
#'@field optimize optimize the model. Expects a vector with starting values,
#'a SEM of type SEM_Cpp, a lambda and an alpha value.
#'@returns a list with fit results
#'
NULL

#'@name glmnetEnetMgSEM
#'@title elastic net optimization with glmnet optimizer
#'@description Object for elastic net optimization with
#'glmnet optimizer
#'@field new creates a new object. Requires (1) a vector with weights for each
#'parameter and (2) a list with control elements
#'@field setHessian changes the Hessian of the model. Expects a matrix
#'@field optimize optimize the model. Expects a vector with starting values,
#'a SEM of type SEM_Cpp, a lambda and an alpha value.
#'@returns a list with fit results
#'
NULL

#'@name istaEnetSEM
#'@title elastic net optimization with ista optimizer
#'@description Object for elastic net optimization with
#'glmnet optimizer
#'@field new creates a new object. Requires (1) a vector with weights for each
#'parameter and (2) a list with control elements
#'@field optimize optimize the model. Expects a vector with starting values,
#'a SEM of type SEM_Cpp, a lambda and an alpha value.
#'@returns a list with fit results
#'
NULL

#'@name istaEnetMgSEM
#'@title elastic net optimization with ista optimizer
#'@description Object for elastic net optimization with
#'glmnet optimizer
#'@field new creates a new object. Requires (1) a vector with weights for each
#'parameter and (2) a list with control elements
#'@field optimize optimize the model. Expects a vector with starting values,
#'a SEM of type SEM_Cpp, a lambda and an alpha value.
#'@returns a list with fit results
#'
NULL

#'@name istaCappedL1GeneralPurpose
#'@title cappedL1 optimization with ista
#'@description Object for cappedL1 optimization with
#'ista optimizer
#'@field new creates a new object. Requires (1) a vector with weights for each
#'parameter and (2) a list with control elements
#'@field optimize optimize the model. Expects a vector with starting values,
#'an R function to compute the fit, an R function to compute the gradients, a
#'list with elements the fit and gradient function require, a theta, lambda and an alpha value (alpha must be 1).
#'@returns a list with fit results
NULL

#'@name istaCappedL1GeneralPurposeCpp
#'@title cappedL1 optimization with ista
#'@description Object for cappedL1 optimization with
#'ista optimizer
#'@field new creates a new object. Requires (1) a vector with weights for each
#'parameter and (2) a list with control elements
#'@field optimize optimize the model. Expects a vector with starting values,
#'a SEXP function pointer to compute the fit, a SEXP function pointer to compute the gradients, a
#'list with elements the fit and gradient function require, a theta, lambda and an alpha value (alpha must be 1).
#'@returns a list with fit results
NULL

#'@name istaEnetGeneralPurpose
#'@title elastic net optimization with ista
#'@description Object for elastic net optimization with
#'ista optimizer
#'@field new creates a new object. Requires (1) a vector with weights for each
#'parameter and (2) a list with control elements
#'@field optimize optimize the model. Expects a vector with starting values,
#'an R function to compute the fit, an R function to compute the gradients, a
#'list with elements the fit and gradient function require, a lambda and an alpha value.
#'@returns a list with fit results
NULL

#'@name glmnetEnetGeneralPurpose
#'@title elastic net optimization with glmnet optimizer
#'@description Object for elastic net optimization with
#'glmnet optimizer
#'@field new creates a new object. Requires (1) a vector with weights for each
#'parameter and (2) a list with control elements
#'@field setHessian changes the Hessian of the model. Expects a matrix
#'@field optimize optimize the model. Expects a vector with starting values,
#'an R function to compute the fit, an R function to compute the gradients, a
#'list with elements the fit and gradient function require, a lambda and an alpha value.
#'@returns a list with fit results
#'
NULL

#'@name istaEnetGeneralPurposeCpp
#'@title elastic net optimization with ista
#'@description Object for elastic net optimization with
#'ista optimizer
#'@field new creates a new object. Requires (1) a vector with weights for each
#'parameter and (2) a list with control elements
#'@field optimize optimize the model. Expects a vector with starting values,
#'a SEXP function pointer to compute the fit, a SEXP function pointer to compute the gradients, a
#'list with elements the fit and gradient function require, a lambda and an alpha value.
#'@returns a list with fit results
NULL

#'@name glmnetEnetGeneralPurposeCpp
#'@title elastic net optimization with glmnet optimizer
#'@description Object for elastic net optimization with
#'glmnet optimizer
#'@field new creates a new object. Requires (1) a vector with weights for each
#'parameter and (2) a list with control elements
#'@field setHessian changes the Hessian of the model. Expects a matrix
#'@field optimize optimize the model. Expects a vector with starting values,
#'a SEXP function pointer to compute the fit, a SEXP function pointer to compute the gradients, a
#'list with elements the fit and gradient function require, a lambda and an alpha value.
#'@returns a list with fit results
NULL

#'@name istaLspGeneralPurpose
#'@title lsp optimization with ista
#'@description Object for lsp optimization with
#'ista optimizer
#'@field new creates a new object. Requires (1) a vector with weights for each
#'parameter and (2) a list with control elements
#'@field optimize optimize the model. Expects a vector with starting values,
#'an R function to compute the fit, an R function to compute the gradients, a
#'list with elements the fit and gradient function require, a theta and a lambda value (alpha must be 1).
#'@returns a list with fit results
NULL

#'@name istaLspGeneralPurposeCpp
#'@title lsp optimization with ista
#'@description Object for lsp optimization with
#'ista optimizer
#'@field new creates a new object. Requires (1) a vector with weights for each
#'parameter and (2) a list with control elements
#'@field optimize optimize the model. Expects a vector with starting values,
#'a SEXP function pointer to compute the fit, a SEXP function pointer to compute the gradients, a
#'list with elements the fit and gradient function require, a theta and a lambda value (alpha must be 1).
#'@returns a list with fit results
NULL

#'@name istaMcpGeneralPurpose
#'@title mcp optimization with ista
#'@description Object for mcp optimization with
#'ista optimizer
#'@field new creates a new object. Requires (1) a vector with weights for each
#'parameter and (2) a list with control elements
#'@field optimize optimize the model. Expects a vector with starting values,
#'an R function to compute the fit, an R function to compute the gradients, a
#'list with elements the fit and gradient function require, a theta and a lambda value (alpha must be 1).
#'@returns a list with fit results
#'
NULL

#'@name istaMcpGeneralPurposeCpp
#'@title mcp optimization with ista
#'@description Object for mcp optimization with
#'ista optimizer
#'@field new creates a new object. Requires (1) a vector with weights for each
#'parameter and (2) a list with control elements
#'@field optimize optimize the model. Expects a vector with starting values,
#'a SEXP function pointer to compute the fit, a SEXP function pointer to compute the gradients, a
#'list with elements the fit and gradient function require, a theta and a lambda value (alpha must be 1).
#'@returns a list with fit results
NULL

#'@name istaScadGeneralPurpose
#'@title scad optimization with ista
#'@description Object for scad optimization with
#'ista optimizer
#'@field new creates a new object. Requires (1) a vector with weights for each
#'parameter and (2) a list with control elements
#'@field optimize optimize the model. Expects a vector with starting values,
#'an R function to compute the fit, an R function to compute the gradients, a
#'list with elements the fit and gradient function require, a theta and a lambda value (alpha must be 1).
#'@returns a list with fit results
NULL

#'@name istaScadGeneralPurposeCpp
#'@title scad optimization with ista
#'@description Object for scad optimization with
#'ista optimizer
#'@field new creates a new object. Requires (1) a vector with weights for each
#'parameter and (2) a list with control elements
#'@field optimize optimize the model. Expects a vector with starting values,
#'a SEXP function pointer to compute the fit, a SEXP function pointer to compute the gradients, a
#'list with elements the fit and gradient function require, a theta and a lambda value (alpha must be 1).
#'@returns a list with fit results
NULL

#'@name istaLSPSEM
#'@title lsp optimization with ista
#'@description Object for lsp optimization with
#'ista optimizer
#'@field new creates a new object. Requires (1) a vector with weights for each
#'parameter and (2) a list with control elements
#'@field optimize optimize the model. Expects a vector with starting values,
#'a SEM of type SEM_Cpp, a theta and a lambda value.
#'@returns a list with fit results
#'
NULL

#'@name istaLSPMgSEM
#'@title lsp optimization with ista
#'@description Object for lsp optimization with
#'ista optimizer
#'@field new creates a new object. Requires (1) a vector with weights for each
#'parameter and (2) a list with control elements
#'@field optimize optimize the model. Expects a vector with starting values,
#'a SEM of type SEM_Cpp, a theta and a lambda value.
#'@returns a list with fit results
#'
NULL

#'@name istaMcpSEM
#'@title mcp optimization with ista
#'@description Object for mcp optimization with
#'ista optimizer
#'@field new creates a new object. Requires (1) a vector with weights for each
#'parameter and (2) a list with control elements
#'@field optimize optimize the model. Expects a vector with starting values,
#'a SEM of type SEM_Cpp, a theta and a lambda value.
#'@returns a list with fit results
NULL

#'@name istaMcpMgSEM
#'@title mcp optimization with ista
#'@description Object for mcp optimization with
#'ista optimizer
#'@field new creates a new object. Requires (1) a vector with weights for each
#'parameter and (2) a list with control elements
#'@field optimize optimize the model. Expects a vector with starting values,
#'a SEM of type SEM_Cpp, a theta and a lambda value.
#'@returns a list with fit results
NULL

#' mcpPenalty_C
#' 
#' @param par single parameter value
#' @param lambda_p lambda value for this parameter
#' @param theta theta value for this parameter
#' @returns penalty value
mcpPenalty_C <- function(par, lambda_p, theta) {
    .Call(`_lessSEM_mcpPenalty_C`, par, lambda_p, theta)
}

#' @name mgSEM
#' 
#' @title mgSEM class
#' 
#' @description internal mgSEM representation
#' 
#' @field new Creates a new mgSEM.
#' @field addModel add a model. Expects Rcpp::List
#' @field addTransformation adds transforamtions to a model
#' @field implied Computes implied means and covariance matrix
#' @field fit Fits the model. Returns -2 log likelihood
#' @field getParameters Returns a data frame with model parameters.
#' @field getParameterLabels Returns a vector with unique parameter labels as used internally.
#' @field getGradients Returns a matrix with scores.
#' @field getScores Returns a matrix with scores. Not yet implemented
#' @field getHessian Returns the hessian of the model. Expects the labels of the 
#' parameters and the values of the parameters as well as a boolean indicating if 
#' these are raw. Finally, a double (eps) controls the precision of the approximation.
#' @field computeTransformations compute the transformations.
#' @field setTransformationGradientStepSize change the step size of the gradient computation for the transformations
NULL

#'@name istaMixedPenaltySEM
#'@title mixed penalty optimization with ista
#'@description Object for elastic net optimization with
#'ista optimizer
#'@field new creates a new object. Requires (1) a vector with weights for each
#'parameter, (2) a vector indicating which penalty is used, and (3) a list with control elements
#'@field optimize optimize the model. Expects a vector with starting values,
#'a SEM of type SEM_Cpp, a theta value, a lambda and an alpha value (alpha must be 1).
#'@returns a list with fit results
NULL

#'@name istaMixedPenaltymgSEM
#'@title mixed penalty optimization with ista
#'@description Object for elastic net optimization with
#'ista optimizer
#'@field new creates a new object. Requires (1) a vector with weights for each
#'parameter, (2) a vector indicating which penalty is used, and (3) a list with control elements
#'@field optimize optimize the model. Expects a vector with starting values,
#'a SEM of type SEM_Cpp, a theta value, a lambda and an alpha value (alpha must be 1).
#'@returns a list with fit results
NULL

#'@name istaScadSEM
#'@title scad optimization with ista
#'@description Object for scad optimization with
#'ista optimizer
#'@field new creates a new object. Requires (1) a vector with weights for each
#'parameter and (2) a list with control elements
#'@field optimize optimize the model. Expects a vector with starting values,
#'a SEM of type SEM_Cpp, a theta and a lambda value.
#'@returns a list with fit results
NULL

#'@name istaScadMgSEM
#'@title scad optimization with ista
#'@description Object for scad optimization with
#'ista optimizer
#'@field new creates a new object. Requires (1) a vector with weights for each
#'parameter and (2) a list with control elements
#'@field optimize optimize the model. Expects a vector with starting values,
#'a SEM of type SEM_Cpp, a theta and a lambda value.
#'@returns a list with fit results
NULL

#' scadPenalty_C
#' 
#' @param par single parameter value
#' @param lambda_p lambda value for this parameter
#' @param theta theta value for this parameter
#' @returns penalty value
scadPenalty_C <- function(par, lambda_p, theta) {
    .Call(`_lessSEM_scadPenalty_C`, par, lambda_p, theta)
}

