% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lets_transf.R
\name{lets.transf}
\alias{lets.transf}
\title{Transform values of a vector}
\usage{
lets.transf(x, y, z, NUMERIC = TRUE)
}
\arguments{
\item{x}{A vector to be transformed.}

\item{y}{levels to be transformed.}

\item{z}{The value to be atributed to each level (same order as y).}

\item{NUMERIC}{logical, if \code{TRUE} z will be considered numbers.}
}
\value{
Return a vector with changed values.
}
\description{
Transform each element of a vector.
}
\examples{
\dontrun{
status <- sample(c("EN","VU", "NT", "CR", "DD", "LC"), 30, replace=TRUE) 
TE <- "Threatened"
NT <- "Non-Threatened"
new <- c(TE, TE, NT, TE, "Data Deficient", NT)
old <- c("EN","VU", "NT", "CR", "DD", "LC")
statustrans <- lets.transf(status, old, new, NUMERIC=FALSE)

}

}
\author{
Bruno Vilela
}

