% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lets_correl.R
\name{lets.correl}
\alias{lets.correl}
\title{Compute correlogram based on the Moran's I index}
\usage{
lets.correl(x, y, z, equidistant = FALSE, plot = TRUE)
}
\arguments{
\item{x}{A single numeric variable in vector format or multiple variables in matrix format 
(as columns).}

\item{y}{A distance matrix of class \code{matrix} or \code{dist}.}

\item{z}{The number of distance classes to use in the correlogram.}

\item{equidistant}{Logical, if \code{TRUE} the classes will be equidistant.
If \code{FALSE} the classes will have equal number of observations.}

\item{plot}{Logical, if \code{TRUE} the correlogram will be ploted.}
}
\value{
Returns a matrix with the Moran's I Observed value, Confidence Interval (95%) 
and Expected value. Also the p value of the randomization test, the mean distance 
between classes, and the number of observations.   
quase tudo
}
\description{
Computes the Moran's I correlogram of a single or multiple variables.
}
\examples{
\dontrun{
data(PAM)
data(IUCN)

# Spatial autocorrelation in description year (species level)
midpoint <- lets.midpoint(PAM)
distan <- lets.distmat(midpoint[, 2:3])
moran <- lets.correl(IUCN$Description, distan, 12,
                     equidistant = FALSE, 
                     plot = TRUE)
                     
}

}
\author{
Bruno Vilela, Fabricio Villalobos, Lucas Jardim & Jose Alexandre Diniz-Filho
}
\references{
Sokal, R.R. & Oden, N.L. (1978) Spatial autocorrelation in biology.
1. Methodology. Biological Journal of the Linnean Society, 10, 199-228.

Sokal, R.R. & Oden, N.L. (1978) Spatial autocorrelation in biology.
2. Some biological implications and four applications of evolutionary and
ecological interest. Biological Journal of the Linnean Society, 10, 229-249.
}

