% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lets_overlap.R
\name{lets.overlap}
\alias{lets.overlap}
\title{Compute pairwise species' geographic overlaps}
\usage{
lets.overlap(pam, method = "Chesser&Zink", xy = NULL)
}
\arguments{
\item{pam}{A presence-absence matrix (sites in rows and species in columns,
with the first two columns containing the longitudinal and latitudinal coordinates, 
respectively), or an object of class \code{\link{PresenceAbsence}}.}

\item{method}{The method used to calculate the overlap matrix. "Chesser&Zink"
calculates the degree of overlap as the proportion of the smaller range that overlaps
within the larger range (Chesser & Zink 1994). "Proportional" calculates the proportion 
of a range that overlaps another range, the resultant matrix is not symmetric. 
"Cells" will show the number of overlapping grid cells between a pair of species' 
ranges (same for both species in a pair), here the resultant matrix is symmetric.}

\item{xy}{Logical, if \code{TRUE} the input matrix contains geographic coordinates in 
the first two columns.}
}
\description{
Creates a species geographic overlap matrix from a 
Presence-absence matrix.
}
\examples{
\dontrun{
data(PAM)
CZ <- lets.overlap(PAM, method = "Chesser&Zink")
prop <- lets.overlap(PAM, method = "Proportional")
cells <- lets.overlap(PAM, method = "Cells")
}
   
}
\references{
Chesser, R. Terry, and Robert M. Zink. "Modes of speciation in birds: a 
test of Lynch's method." Evolution (1994): 490-497.

Barraclough, Timothy G., and Alfried P. Vogler. "Detecting the geographical 
pattern of speciation from species-level phylogenies." The American Naturalist 155.4 
(2000): 419-434.
}
\seealso{
\code{\link{lets.presab}}

\code{\link{lets.presab.birds}}
}
\author{
Fabricio Villalobos & Bruno Vilela
}
