#' Loughran-McDonald Polarity Table
#'
#' A \pkg{data.table} dataset containing an filtered version of Loughran &
#' McDonald's (2016) positive/negative financial word list as sentiment lookup
#' values.
#'
#' @details
#' \itemize{
#'   \item x. Words
#'   \item y. Sentiment values
#' }
#'
#' @section License: The original authors note the data is available for 
#' non-commercial, research use: "The data compilations provided on 
#' this website are for use by individual researchers.".  For more details see:
#' https://sraf.nd.edu/textual-analysis/resources/#Master%20Dictionary.
#' @section Copyright: Copyright holder University of Notre Dame
#' @docType data
#' @keywords datasets
#' @name hash_sentiment_loughran_mcdonald
#' @usage data(hash_sentiment_loughran_mcdonald)
#' @format A data frame with 2,702 rows and 2 variables
#' @references Loughran, T. and McDonald, B. (2016). Textual analysis in
#' accounting and finance: A survey. Journal of Accounting Research 54(4),
#' 1187-1230. doi: 10.2139/ssrn.2504147 \cr \cr
#' \url{https://sraf.nd.edu/textual-analysis/resources/#Master\%20Dictionary}
NULL


