% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/self.R
\name{self}
\alias{self}
\title{Semi-Supervised Local Fisher Discriminant Analysis(SELF) for
Semi-Supervised Dimensionality Reduction}
\usage{
self(X, Y, beta = 0.5, r, metric = c("orthonormalized", "plain",
  "weighted"), kNN = 5, minObsPerLabel = 5)
}
\arguments{
\item{X}{n x d matrix of original samples.
n is the number of samples.}

\item{Y}{length n vector of class labels}

\item{beta}{degree of semi-supervisedness (0 <= beta <= 1; default is 0.5 )
0: totally supervised (discard all unlabeled samples)
1: totally unsupervised (discard all label information)}

\item{r}{dimensionality of reduced space (default: d)}

\item{metric}{type of metric in the embedding space (no default)
'weighted'        --- weighted eigenvectors
'orthonormalized' --- orthonormalized
'plain'           --- raw eigenvectors}

\item{kNN}{parameter used in local scaling method (default: 5)}

\item{minObsPerLabel}{the minimum number observations required for each different label(default: 5)}
}
\value{
list of the SELF results:
\item{T}{d x r transformation matrix (Z = x * T)}
\item{Z}{n x r matrix of dimensionality reduced samples}
}
\description{
Performs semi-supervised local fisher discriminant analysis (SELF) on the given data.
SELF is a linear semi-supervised dimensionality reduction method smoothly bridges supervised
LFDA and unsupervised principal component analysis, by which a natural regularization effect
can be obtained when only a small number of labeled samples are available.
}
\examples{
\dontrun{
X <- iris[,-5]
Y <- iris[,5]
result <- self(X,Y,beta = 0.1, r = 3, metric = "plain")
}
}
\author{
Yuan Tang
}
\references{
Sugiyama, Masashi, et al (2010).
Semi-supervised local Fisher discriminant analysis for dimensionality reduction.
\emph{Machine learning} 78.1-2: 35-61.

Sugiyama, M (2007).
Dimensionality reduction of multimodal labeled data by
local Fisher discriminant analysis.
\emph{Journal of Machine Learning Research}, vol.\bold{8}, 1027--1061.

Sugiyama, M (2006).
Local Fisher discriminant analysis for supervised dimensionality reduction.
In W. W. Cohen and A. Moore (Eds.), \emph{Proceedings of 23rd International
Conference on Machine Learning (ICML2006)}, 905--912.
}
\seealso{
See \code{\link{lfda}} for LFDA and  \code{\link{klfda}} for the kernelized variant of
         LFDA (Kernel LFDA).
}
\keyword{discriminant}
\keyword{fisher}
\keyword{lfda}
\keyword{local}
\keyword{mahalanobis}
\keyword{metric}
\keyword{semi-supervised}
\keyword{transformation}

