\name{ginhomAverage}
\alias{ginhomAverage}
\title{ginhomAverage function...}
\usage{ginhomAverage(xyt, spatial.intensity, temporal.intensity,
    time.window=xyt$tlim, rvals, correction="iso",
    suppresswarnings=FALSE)}
\description{ginhomAverage function}
\details{A function to estimate the inhomogeneous pair correlation function for a spatiotemporal point process. See equation (8) of Diggle P, Rowlingson B, Su T (2005).}
\value{time average of inhomogenous pcf, equation (13) of Brix and Diggle 2001.}
\references{\enumerate{
\item Baddeley AJ, Moller J, Waagepetersen R (2000). Non-and semi-parametric estimation of interaction in inhomogeneous point patterns. Statistica Neerlandica, 54, 329-350.
\item Brix A, Diggle PJ (2001). Spatiotemporal Prediction for log-Gaussian Cox processes. Journal of the Royal Statistical Society, Series B, 63(4), 823-841.
\item Diggle P, Rowlingson B, Su T (2005). Point Process Methodology for On-line Spatio-temporal Disease Surveillance. Environmetrics, 16(5), 423-434.
}}
\seealso{\link{KinhomAverage}, \link{spatialparsEst}, \link{thetaEst}, \link{lambdaEst}, \link{muEst}}
\arguments{\item{xyt}{an object of class stppp}
\item{spatial.intensity}{A spatialAtRisk object}
\item{temporal.intensity}{A temporalAtRisk object}
\item{time.window}{time interval contained in the interval xyt$tlim over which to compute average. Useful if there is a lot of data over a lot of time points.}
\item{rvals}{Vector of values for the argument r at which g(r) should be evaluated (see ?pcfinhom). There is a sensible default.}
\item{correction}{choice of edge correction to use, see ?pcfinhom, default is Ripley isotropic correction}
\item{suppresswarnings}{Whether or not to suppress warnings generated by pcfinhom}}
