% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameterEstimation.R
\name{spatialparsEst}
\alias{spatialparsEst}
\title{spatialparsEst function}
\usage{
spatialparsEst(gk, sigma.range, phi.range, spatial.covmodel, covpars = c(),
  guess = FALSE)
}
\arguments{
\item{gk}{an R object; output from the function KinhomAverage or ginhomAverage}

\item{sigma.range}{range of sigma values to consider}

\item{phi.range}{range of phi values to consider}

\item{spatial.covmodel}{correlation type see ?CovarianceFct}

\item{covpars}{vector of additional parameters for certain classes of covariance function (eg Matern), these must be supplied in the order given in ?CovarianceFct}

\item{guess}{logical. Perform an initial guess at paramters? Alternative (the default) sets initial values in the middle of sigma.range and phi.range. NOTE: automatic parameter estimation can be can be unreliable.}
}
\value{
rpanel function to help choose sigma nad phi by eye
}
\description{
Having estimated either the pair correlation or K functions using respectively \link{ginhomAverage} or \link{KinhomAverage}, the spatial 
parameters sigma and phi can be estimated. This function provides a visual tool for this estimation procedure.
}
\details{
To get a good choice of parameters, it is likely that the routine will have to be called several times in order to refine 
the choice of sigma.range and phi.range.
}
\references{
\enumerate{
    \item Benjamin M. Taylor, Tilman M. Davies, Barry S. Rowlingson, Peter J. Diggle (2013). Journal of Statistical Software, 52(4), 1-40. URL http://www.jstatsoft.org/v52/i04/
    \item Baddeley AJ, Moller J, Waagepetersen R (2000). Non-and semi-parametric estimation of interaction in inhomogeneous point patterns. Statistica Neerlandica, 54, 329-350.
    \item Brix A, Diggle PJ (2001). Spatiotemporal Prediction for log-Gaussian Cox processes. Journal of the Royal Statistical Society, Series B, 63(4), 823-841.
    \item Diggle P, Rowlingson B, Su T (2005). Point Process Methodology for On-line Spatio-temporal Disease Surveillance. Environmetrics, 16(5), 423-434.
}
}
\seealso{
\link{ginhomAverage}, \link{KinhomAverage}, \link{thetaEst}, \link{lambdaEst}, \link{muEst}
}

