% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Appender.R
\name{AppenderFile}
\alias{AppenderFile}
\title{Log to a File}
\description{
A simple Appender that outputs to a file in the file system. If you plan
to log to text files, consider logging to JSON files and take a look at
\link{AppenderJson}, which is more or less a shortcut for \code{AppenderFile} with
\code{\link{LayoutJson}} and a few extra methods for convenience.
}
\section{Usage}{
\preformatted{
x <- AppenderFile$new(file, threshold = NA_integer_, layout =
  LayoutFormat$new(), filters = NULL)

x$append(event)
x$set_file(file)
x$set_threshold(level)
x$set_layout(layout)
x$filter(event)
x$add_filter(filter, name = NULL)
x$remove_filter(pos)
x$set_filters(filters)

x$destination
x$file
x$layout
x$threshold
x$filters

}
}

\section{Fields}{


\describe{
\item{\code{file}, \code{set_file(file)}}{\code{character} scalar. Path to the desired log
file. If the file does not exist it will be created}
}



\describe{
\item{\code{threshold}, \code{set_threshold(level)}}{\code{character} or \code{integer} scalar.
The minimum log level that triggers this logger. See \link{log_levels}}
\item{\code{layout}, \code{set_layout(layout)}}{a \code{Layout} that will be used for
formatting the \code{LogEvents} passed to this Appender}
\item{\code{destination}}{The output destination of the \code{Appender} in
human-readable form (mainly for print output)}
}



\describe{
\item{\code{filters}, \code{set_filters(filters)}}{a \code{list} that may contain
\code{functions} or any \R object with a \code{filter()} method. These functions
must have exactly one argument: \code{event} which will get passed the
LogEvent when the Filterable's \code{filter()} method is invoked.
If all of these functions evaluate to \code{TRUE} the LogEvent is passed on.
Since LogEvents have reference semantics, filters can also be abused to
modify them before they are passed on. Look at the source code of
\code{\link[=with_log_level]{with_log_level()}} or \code{\link[=with_log_value]{with_log_value()}} for examples.
}
}
}

\section{Creating a New Appender}{


New Appenders are instantiated with \code{<AppenderSubclass>$new()}. For the
arguments to \code{new()} please refer to the section \emph{Fields}. You can also
modify those fields after the Appender has been created with setters in the
form of \code{appender$set_<fieldname>(value)}
}

\section{Methods}{

\describe{
\item{\code{append(event)}}{Tell the Appender to process a \link{LogEvent} \code{event}.
This method is usually not called by the user, but invoked by a
\link{Logger}
}
}


\describe{
\item{\code{filter(event)}}{Determine whether the LogEvent \code{x} should be passed
on to Appenders (\code{TRUE}) or not (\code{FALSE}). See also the active binding
\code{filters}}
\item{\code{add_filter(filter, name = NULL)}, \code{remove_filter(pos)}}{
Add or remove a filter. When adding a filter an optional \code{name} can
be specified. \code{remove_filter()} can remove by position or name (if one
was specified)
}
}
}

\examples{
logger <- Logger$new("loggername")
default <- tempfile()
fancy <- tempfile()
json <- tempfile()

logger$add_appender(AppenderFile$new(default), "default")
logger$add_appender(
  AppenderFile$new(fancy, layout = LayoutFormat$new("[\%t] \%c(): \%L \%m")), "fancy"
)
logger$add_appender(
  AppenderFile$new(json, layout = LayoutJson$new()), "json"
)

logger$info("A test message")

readLines(default)
readLines(fancy)
readLines(json)
}
\seealso{
\link{LayoutFormat}, \link{LayoutJson}

Other Appenders: \code{\link{AppenderBuffer}},
  \code{\link{AppenderConsole}}, \code{\link{AppenderDbi}},
  \code{\link{AppenderGmail}}, \code{\link{AppenderJson}},
  \code{\link{AppenderPushbullet}},
  \code{\link{AppenderRjdbc}},
  \code{\link{AppenderSendmail}},
  \code{\link{AppenderTable}}, \code{\link{Appender}}
}
\concept{Appenders}
