% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Layout.R
\name{LayoutDbi}
\alias{LayoutDbi}
\alias{LayoutSqlite}
\alias{LayoutRjdbc}
\alias{LayoutRjdbcDb2}
\alias{LayoutDb2}
\alias{LayoutMySql}
\alias{LayoutPostgres}
\title{Format Log Events for Output to Databases}
\description{
LayoutDbi can contain \code{col_types} that \link{AppenderDbi} can use to create new
database tables; however, it is safer and more flexible to set up the log
table up manually with an \code{SQL CREATE TABLE} statement instead.
}
\details{
The LayoutDbi parameters \code{fmt}, \code{timestamp_fmt}, \code{colors} and \code{pad_levels}
are only applied for for console output via the \code{$show()} method and do not
influence database inserts in any way. The inserts are pre-processed by
the methods \code{$format_data()}, \code{$format_colnames} and \code{$format_tablenames}.

It does not format
LogEvents directly, but their \code{data.table} representations (see
\link{as.data.table.LogEvent}), as well as column- and table names.
}
\section{Usage}{
\preformatted{
x <- LayoutDbi$new(col_types = NULL, fmt = "\%L [\%t] \%m \%f", timestamp_fmt =
  "\%Y-\%m-\%d \%H:\%M:\%S", colors = getOption("lgr.colors", list()), pad_levels =
  "right", format_table_name = identity, format_colnames = identity,
  format_data = identity)

x$clone(deep = FALSE)
x$format_event(event)
x$set_col_types(x)
x$set_colors(x)
x$set_fmt(x)
x$set_pad_levels(x)
x$set_timestamp_fmt(x)
x$sql_create_table(table)

x$col_names
x$col_types
x$colors
x$fmt
x$format_colnames
x$format_data
x$format_table_name
x$pad_levels
x$timestamp_fmt

}
}

\section{Creating a New Layout}{




Layouts are instantiated with \code{<LayoutSubclass>$new()}. For a description of
the arguments to this function please refer to the Fields section.
}

\section{Fields}{


\describe{
\item{\code{col_types}}{A named \code{character} vector of column types supported by
the target database. If not \code{NULL} this is used by \link{AppenderDbi} or similar
Appenders to create a new database table on instantiation of the Appender. If
the target database table already exists, \code{col_types} is not used.
}
\item{\code{col_names}}{Convenience method to get the names of the \code{col_types}
vector}
}
}

\section{Methods}{


\describe{
\item{\code{format_table_name(x)}}{Format table names before inserting into
the database. For example some databases prefer all lowercase names,
some uppercase. SQL updates should be case-agnostic, but sadly in
practice not all DBI backends behave consistently in this regard}
\item{\code{format_colnames}}{Format column names before inserting into the
database. See \code{$format_table_name} for more info}
\item{\code{format_data}}{Format the input \code{data.table} before inserting into
the database. Usually this function does nothing, but for example for
SQLite it has to apply formatting to the timestamp.
}
\item{\code{col_names}}{Convenience method to get the names of the \code{col_types}
vector}
}



\describe{
\item{\code{format_event(event)}}{format a \link{LogEvent}}
}
}

\section{Database Specific Layouts}{


Different databases have different data types and features. Currently the
following \code{LayoutDbi} subclasses exist that deal with specific databases,
but this list is expected to grow as lgr matures:
\itemize{
\item \code{LayoutSqlite}: For SQLite databases
\item \code{LayoutPostgres}: for Postgres databases
\item \code{LayoutMySql}: for MySQL databases
\item \code{LayoutDb2}: for DB2 databases
}

The utility function \code{\link[=select_dbi_layout]{select_dbi_layout()}} tries returns the appropriate
Layout for a DBI connection, but this does not work for odbc and JDBC
connections where you have to specify the layout manually.
}

\seealso{
\code{\link[=select_dbi_layout]{select_dbi_layout()}}, \link[DBI:DBI]{DBI::DBI},

Other Layouts: \code{\link{LayoutFormat}},
  \code{\link{LayoutGlue}}, \code{\link{LayoutJson}},
  \code{\link{Layout}}
}
\concept{Layouts}
\concept{database layouts}
