% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Appender.R
\name{AppenderFile}
\alias{AppenderFile}
\alias{AppenderJson}
\title{Log to a file}
\description{
A simple Appender that outputs to a file in the file system. If you plan
to log to text files, consider logging to JSON files and take a look at
\link{AppenderJson}, which is a shortcut for \code{AppenderFile} preconfigured with
\code{\link{LayoutJson}}.
}
\examples{
lg <- get_logger("test")
default <- tempfile()
fancy <- tempfile()
json <- tempfile()

lg$add_appender(AppenderFile$new(default), "default")
lg$add_appender(
  AppenderFile$new(fancy, layout = LayoutFormat$new("[\%t] \%c(): \%L \%m")), "fancy"
)
lg$add_appender(
  AppenderFile$new(json, layout = LayoutJson$new()), "json"
)

lg$info("A test message")

readLines(default)
readLines(fancy)
readLines(json)

# cleanup
lg$config(NULL)
unlink(default)
unlink(fancy)
unlink(json)
tf <- tempfile()
lg <- get_logger("test")$
  set_appenders(AppenderJson$new(tf))$
  set_propagate(FALSE)

lg$info("A test message")
lg$info("A test message \%s strings", "with format strings", and = "custom_fields")

lg$appenders[[1]]$show()
lg$appenders[[1]]$data

# cleanup
lg$config(NULL)
unlink(tf)
}
\seealso{
\link{LayoutFormat}, \link{LayoutJson}

\link{LayoutFormat}, \link{LayoutJson}

Other Appenders: 
\code{\link{AppenderBuffer}},
\code{\link{AppenderConsole}},
\code{\link{AppenderFileRotatingDate}},
\code{\link{AppenderFileRotatingTime}},
\code{\link{AppenderFileRotating}},
\code{\link{AppenderTable}},
\code{\link{Appender}}

Other Appenders: 
\code{\link{AppenderBuffer}},
\code{\link{AppenderConsole}},
\code{\link{AppenderFileRotatingDate}},
\code{\link{AppenderFileRotatingTime}},
\code{\link{AppenderFileRotating}},
\code{\link{AppenderTable}},
\code{\link{Appender}}
}
\concept{Appenders}
\section{Super classes}{
\code{\link[lgr:Filterable]{lgr::Filterable}} -> \code{\link[lgr:Appender]{lgr::Appender}} -> \code{AppenderFile}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{file}}{\code{character} scalar. path to the log file}

\item{\code{data}}{\code{character} scalar. Contents of \code{file} parsed to a
\code{data.frame} if used with a \link{Layout} that supports parsing of log
file data (notably \link{LayoutJson}).}

\item{\code{data}}{\code{character} scalar. Like \verb{$data}, but returns a \code{data.table}
instead (requires the \strong{data.table} package).}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{AppenderFile$new()}}
\item \href{#method-append}{\code{AppenderFile$append()}}
\item \href{#method-set_file}{\code{AppenderFile$set_file()}}
\item \href{#method-show}{\code{AppenderFile$show()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="add_filter">}\href{../../lgr/html/Filterable.html#method-add_filter}{\code{lgr::Filterable$add_filter()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="filter">}\href{../../lgr/html/Filterable.html#method-filter}{\code{lgr::Filterable$filter()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="remove_filter">}\href{../../lgr/html/Filterable.html#method-remove_filter}{\code{lgr::Filterable$remove_filter()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="set_filters">}\href{../../lgr/html/Filterable.html#method-set_filters}{\code{lgr::Filterable$set_filters()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Appender" data-id="format">}\href{../../lgr/html/Appender.html#method-format}{\code{lgr::Appender$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Appender" data-id="set_layout">}\href{../../lgr/html/Appender.html#method-set_layout}{\code{lgr::Appender$set_layout()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Appender" data-id="set_threshold">}\href{../../lgr/html/Appender.html#method-set_threshold}{\code{lgr::Appender$set_threshold()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderFile$new(
  file,
  threshold = NA_integer_,
  layout = LayoutFormat$new(),
  filters = NULL
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-append"></a>}}
\if{latex}{\out{\hypertarget{method-append}{}}}
\subsection{Method \code{append()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderFile$append(event)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_file"></a>}}
\if{latex}{\out{\hypertarget{method-set_file}{}}}
\subsection{Method \code{set_file()}}{
Set a log file
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderFile$set_file(file)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{\code{character} scalar. Path to the log file. If \code{file} does not
exist it will be created.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-show"></a>}}
\if{latex}{\out{\hypertarget{method-show}{}}}
\subsection{Method \code{show()}}{
Display the contents of the log file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderFile$show(threshold = NA_integer_, n = 20L)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{threshold}}{\code{character} or \code{integer} scalar. The minimum log level
that should be displayed.}

\item{\code{n}}{\code{integer} scalar. Show only the last \code{n} log entries that match
\code{threshold}.}
}
\if{html}{\out{</div>}}
}
}
}
\section{Super classes}{
\code{\link[lgr:Filterable]{lgr::Filterable}} -> \code{\link[lgr:Appender]{lgr::Appender}} -> \code{\link[lgr:AppenderFile]{lgr::AppenderFile}} -> \code{AppenderJson}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{AppenderJson$new()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="add_filter">}\href{../../lgr/html/Filterable.html#method-add_filter}{\code{lgr::Filterable$add_filter()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="filter">}\href{../../lgr/html/Filterable.html#method-filter}{\code{lgr::Filterable$filter()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="remove_filter">}\href{../../lgr/html/Filterable.html#method-remove_filter}{\code{lgr::Filterable$remove_filter()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="set_filters">}\href{../../lgr/html/Filterable.html#method-set_filters}{\code{lgr::Filterable$set_filters()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Appender" data-id="format">}\href{../../lgr/html/Appender.html#method-format}{\code{lgr::Appender$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Appender" data-id="set_layout">}\href{../../lgr/html/Appender.html#method-set_layout}{\code{lgr::Appender$set_layout()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Appender" data-id="set_threshold">}\href{../../lgr/html/Appender.html#method-set_threshold}{\code{lgr::Appender$set_threshold()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="AppenderFile" data-id="append">}\href{../../lgr/html/AppenderFile.html#method-append}{\code{lgr::AppenderFile$append()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="AppenderFile" data-id="set_file">}\href{../../lgr/html/AppenderFile.html#method-set_file}{\code{lgr::AppenderFile$set_file()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="AppenderFile" data-id="show">}\href{../../lgr/html/AppenderFile.html#method-show}{\code{lgr::AppenderFile$show()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderJson$new(
  file,
  threshold = NA_integer_,
  layout = LayoutJson$new(),
  filters = NULL
)}\if{html}{\out{</div>}}
}

}
}
