% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AppenderDt.R
\name{AppenderDt}
\alias{AppenderDt}
\title{Log to an in-memory data.table}
\value{
The \verb{$new()} method returns an \link[R6:R6Class]{R6::R6} that inherits from
\link[lgr:Appender]{lgr::Appender} and can be uses as an appender by a \link[lgr:Logger]{lgr::Logger}.
}
\description{
An Appender that outputs to an in-memory \code{data.table}. It fulfill a similar
purpose as the more flexible \link{AppenderBuffer} and is mainly included for
historical reasons/backwards compatibility with older version of \strong{lgr}.

\strong{NOTE}: AppenderDt has been superseded by \link[lgr:AppenderBuffer]{lgr::AppenderBuffer} and is
kept mainly for archival purposes.
}
\section{Custom Fields}{


\code{AppenderDt} supports \link[=LogEvent]{custom fields}, but they have to be
pre-allocated in the \code{prototype} argument. Custom fields that are not
part of the prototype are inserted in the list-column \code{.fields} if it
exists.
}

\section{Creating a Data Table Appender}{


In addition to the usual fields, \code{AppenderDt$new()} requires that you supply
a \code{buffer_size} and a \code{prototype}. These determine the structure of the
\code{data.table} used to store the log this appender creates and cannot be
modified anymore after the instantiation of the appender.

The \link[lgr:Layout]{lgr::Layout} for this Appender is used only to format console output of
its \verb{$show()} method.
}

\section{Comparison AppenderBuffer and AppenderDt}{


Both \link{AppenderBuffer} and \link{AppenderDt} do in memory buffering of events.
AppenderBuffer retains a copies of the events it processes and has the
ability to pass the buffered events on to other Appenders. AppenderDt
converts the events to rows in a \code{data.table} and is a bit harder to
configure. Used inside loops (several hundred iterations),
AppenderDt has much less overhead than AppenderBuffer. For single logging
calls and small loops, AppenderBuffer is more performant. This is related to
how memory pre-allocation is handled by the appenders.
}

\examples{
lg <- lgr::get_logger("test")
lg$config(list(
  appenders = list(memory = AppenderDt$new()),
  threshold = NA,
  propagate = FALSE  # to prevent routing to root logger for this example
))
lg$debug("test")
lg$error("test")

# Displaying the log
lg$appenders$memory$data
lg$appenders$memory$show()
lgr::show_log(target = lg$appenders$memory)

# If you pass a Logger to show_log(), it looks for the first AppenderDt
# that it can find.
lgr::show_log(target = lg)

# Custom fields are stored in the list column .fields by default
lg$info("the iris data frame", caps = LETTERS[1:5])
lg$appenders$memory$data
lg$appenders$memory$data$.fields[[3]]$caps
lg$config(NULL)
}
\seealso{
\link[data.table:data.table]{data.table::data.table}

Other Appenders: 
\code{\link{AppenderDbi}},
\code{\link{AppenderElasticSearch}},
\code{\link{AppenderGmail}},
\code{\link{AppenderPushbullet}},
\code{\link{AppenderSendmail}},
\code{\link{AppenderSyslog}}
}
\concept{Appenders}
\section{Super classes}{
\code{\link[lgr:Filterable]{lgr::Filterable}} -> \code{\link[lgr:Appender]{lgr::Appender}} -> \code{AppenderDt}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{AppenderDt$new()}}
\item \href{#method-append}{\code{AppenderDt$append()}}
\item \href{#method-show}{\code{AppenderDt$show()}}
\item \href{#method-set_layout}{\code{AppenderDt$set_layout()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="add_filter">}\href{../../lgr/html/Filterable.html#method-add_filter}{\code{lgr::Filterable$add_filter()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="filter">}\href{../../lgr/html/Filterable.html#method-filter}{\code{lgr::Filterable$filter()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="remove_filter">}\href{../../lgr/html/Filterable.html#method-remove_filter}{\code{lgr::Filterable$remove_filter()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="set_filters">}\href{../../lgr/html/Filterable.html#method-set_filters}{\code{lgr::Filterable$set_filters()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Appender" data-id="format">}\href{../../lgr/html/Appender.html#method-format}{\code{lgr::Appender$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Appender" data-id="set_threshold">}\href{../../lgr/html/Appender.html#method-set_threshold}{\code{lgr::Appender$set_threshold()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creating a new AppenderDt
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderDt$new(
  threshold = NA_integer_,
  layout = LayoutFormat$new(fmt = "\%L [\%t] \%m \%f", timestamp_fmt = "\%H:\%M:\%OS3",
    colors = getOption("lgr.colors", list())),
  prototype = data.table::data.table(.id = NA_integer_, level = NA_integer_, timestamp
    = Sys.time(), logger = NA_character_, caller = NA_character_, msg = NA_character_,
    .fields = list(list())),
  buffer_size = 1e+05,
  filters = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prototype}}{A prototype \code{data.table}. The prototype must be a
\code{data.table} with the same columns and column types as the data
you want to log. The actual content of the columns is irrelevant.
There are a few reserved column names that have special meaning:
* \code{.id}: \code{integer} (mandatory). Must always be the first column
and is used internally by the Appender
* \code{.fields}: \code{list} (optional). If present all custom values of the
event (that are not already part of the prototype) are stored in
this list column.}

\item{\code{buffer_size}}{\code{integer} scalar. Number of rows of the in-memory \code{data.table}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-append"></a>}}
\if{latex}{\out{\hypertarget{method-append}{}}}
\subsection{Method \code{append()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderDt$append(event)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-show"></a>}}
\if{latex}{\out{\hypertarget{method-show}{}}}
\subsection{Method \code{show()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderDt$show(threshold = NA_integer_, n = 20L)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_layout"></a>}}
\if{latex}{\out{\hypertarget{method-set_layout}{}}}
\subsection{Method \code{set_layout()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AppenderDt$set_layout(layout)}\if{html}{\out{</div>}}
}

}
}
