% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/the-web.R
\name{oclc_classify_link_from_standard_num}
\alias{oclc_classify_link_from_standard_num}
\title{Get OCLC Classify link from a standard number}
\usage{
oclc_classify_link_from_standard_num(x)
}
\arguments{
\item{x}{A string (or vector of strings) of a standard number.
Must be an ISSN, ISBN, UPC, and/or OCLC numbers.}
}
\value{
Links to OCLC's Classify web service
}
\description{
Takes a string representation of ISSNs, ISBNs, UPC,
or OCLC numbers.
Returns a link to the OCLC's experimental classify
service which provides the most frequent call numbers,
FAST subject headings, etc...
}
\details{
Since this can take a variety of standard numbers, no
normalization can be performed. The numbers much be normalized
before the call to this function.
No validity check on the URL is performed
}
\examples{

oclc_classify_link_from_standard_num("629725006")
# "http://classify.oclc.org/classify2/ClassifyDemo?search-standnum-txt=629725006&startRec=0"

oclc_classify_link_from_standard_num(c("039333712X", NA, "629725006"))
# [1] "http://classify.oclc.org/classify2/ClassifyDemo?search-standnum-txt=039333712X&startRec=0"
# [2] NA
# [3] "http://classify.oclc.org/classify2/ClassifyDemo?search-standnum-txt=629725006&startRec=0"

}
