% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_typecast.r
\name{as.raster.lasmetrics}
\alias{as.raster.lasmetrics}
\title{Transform a \code{lasmetrics} object into a spatial \code{RasterLayer} object}
\usage{
\method{as.raster}{lasmetrics}(x, z = NULL, ...)
}
\arguments{
\item{x}{a \code{lasmetrics} object}

\item{z}{character. The field to plot. If NULL, autodetect}

\item{\dots}{other parameters for \link[data.table:dcast]{dcast}}
}
\value{
A RasterLayer object from package  \link[raster:raster]{raster}
}
\description{
Transform a \code{lasmetrics} object into a spatial \code{RasterLayer} object
}
\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
lidar = readLAS(LASfile)

meanHeight = grid_metrics(lidar, mean(Z))
rmeanHeight = as.raster(meanHeight)
}
\seealso{
\link[lidR:grid_metrics]{grid_metrics}
\link[lidR:grid_canopy]{grid_canopy}
\link[lidR:grid_canopy]{grid_canopy}
\link[raster:raster]{raster}
\link[data.table:dcast]{dcast}

Other cast: \code{\link{as.SpatialPixelsDataFrame}},
  \code{\link{as.SpatialPointsDataFrame}},
  \code{\link{as.lasmetrics}}
}
