% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid_density.r
\name{grid_density}
\alias{grid_density}
\title{Map the pulse or point density}
\usage{
grid_density(x, res = 4, filter = "")
}
\arguments{
\item{x}{An object of class \link{LAS} or a \link{catalog} (see section "Use with a LAScatalog")}

\item{res}{numeric. The size of a grid cell in LiDAR data coordinates units. Default is 4 = 16
square meters.}

\item{filter}{character. Streaming filter while reading the files (see \link{readLAS}).
If \code{x} is a \code{LAScatalog} the function \link{readLAS} is called internally. The
user cannot manipulate the lidar data directly but can use streaming filters instead.}
}
\value{
Returns a \code{data.table} of class \code{lasmetrics} which enables easier
plotting and RasterLayer casting.
}
\description{
Creates a map of the point density. If a "pulseID" field is found, return also a map of the pulse
density.
}
\section{Use with a \code{LAScatalog}}{

When the parameter \code{x} is a \link[lidR:LAScatalog-class]{LAScatalog} the function processes
the entire dataset in a continuous way using a multicore process. The user can modify the processing
options using the \link[lidR:catalog]{available options}.\cr\cr
\code{lidR} support .lax files. Computation speed will be \emph{significantly} improved with a
spatial index.
}

\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
lidar = readLAS(LASfile)

d = grid_density(lidar, 5)
plot(d)
d = grid_density(lidar, 10)
plot(d)
}
\seealso{
\link[lidR:grid_metrics]{grid_metrics}
}
