% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io_writeLAS.R
\name{writeLAS}
\alias{writeLAS}
\title{Write a .las or .laz file}
\usage{
writeLAS(las, file, index = FALSE)
}
\arguments{
\item{las}{an object of class LAS.}

\item{file}{character. A character string naming an output file.}

\item{index}{boolean. Also write a lax file to index the points in the files}
}
\value{
Nothing. This function is used for its side-effect of writing a file.
}
\description{
Write a \link[lidR:LAS-class]{LAS} object into a binary .las or .laz file (compression
specified in filename)
}
\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
las = readLAS(LASfile)
subset = clip_rectangle(las, 684850, 5017850, 684900, 5017900)
writeLAS(subset, tempfile(fileext = ".laz"))
}
