% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth_height.R
\name{smooth_height}
\alias{smooth_height}
\alias{unsmooth_height}
\title{Smooth a point cloud}
\usage{
smooth_height(
  las,
  size,
  method = c("average", "gaussian"),
  shape = c("circle", "square"),
  sigma = size/6
)

unsmooth_height(las)
}
\arguments{
\item{las}{An object of class \code{LAS}}

\item{size}{numeric. The size of the windows used to smooth.}

\item{method}{character. Smoothing method. Can be 'average' or 'gaussian'.}

\item{shape}{character. The shape of the windows. Can be circle or square.}

\item{sigma}{numeric. The standard deviation of the gaussian if the method is gaussian.}
}
\value{
An object of the class \code{LAS}.
}
\description{
Point cloud-based smoothing algorithm. Two methods are available: average within a window and
Gaussian smooth within a window. The attribute \code{Z} of the returned LAS object is the smoothed Z.
A new attribute \code{Zraw} is added to store the original values and can be used to restore the
point cloud with \code{unsmooth_height}.
}
\details{
This method does not use raster-based methods to smooth the point cloud. This is a true point cloud
smoothing. It is not really useful by itself but may be interesting in combination with filters such
as \link{filter_surfacepoints}, for example to develop new algorithms.
}
\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
las <- readLAS(LASfile, select = "xyz")

las <- filter_surfacepoints(las, 1)
#plot(las)

las <- smooth_height(las, 5, "gaussian", "circle", sigma = 2)
#plot(las)

las <- unsmooth_height(las)
#plot(las)
}
