% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_metrics.R
\name{plot_metrics}
\alias{plot_metrics}
\title{Computes metrics for each plot of a ground inventory}
\usage{
plot_metrics(las, func, geometry, ...)
}
\arguments{
\item{las}{An object of class \link[lidR:LAS-class]{LAS} or \link[lidR:LAScatalog-class]{LAScatalog}.}

\item{func}{formula. An expression to be applied to each cell (see also \link{grid_metrics}).}

\item{geometry}{a spatial object. Many types are supported (see also \link{clip_roi})}

\item{...}{optional supplementary options (see also \link{clip_roi})}
}
\value{
An `sp` or `sf` object depending on the input with all the metrics for each plot bound
with the original input.
}
\description{
Computes metrics for each plot of a ground inventory by 1. clipping the plots inventories, 2. computing
a user's metrics to each plot, and 3. combining spatial data and metrics into one data.frame ready for
statistical modelling. `plot_metrics` is basically a seamless wrapper around \link{clip_roi},
\link{cloud_metrics}, `cbind` and adequate processing settings.
}
\section{Working with a \code{LAScatalog}}{

This section appears in each function that supports a LAScatalog as input.\cr

In \code{lidR} when the input of a function is a \link[lidR:LAScatalog-class]{LAScatalog} the
function uses the LAScatalog processing engine. The user can modify the engine options using
the \link[lidR:catalog_options_tools]{available options}. A careful reading of the
\link[lidR:LAScatalog-class]{engine documentation} is recommended before processing \code{LAScatalogs}. Each
\code{lidR} function should come with a section that documents the supported engine options.\cr

The \code{LAScatalog} engine supports \code{.lax} files that \emph{significantly} improve the computation
speed of spatial queries using a spatial index. Users should really take advantage a \code{.lax} files,
but this is not mandatory.\cr
}

\section{Supported processing options}{

Supported processing options for a \code{LAScatalog} in \code{plot_metrics} function (in bold). For
more details see the \link[lidR:LAScatalog-class]{LAScatalog engine documentation}:
\itemize{
\item chunk size: Not relevant here.
\item chunk buffer: Not relevant here.
\item chunk alignment: Not relevant here.
\item \strong{progress}: Displays a progress estimate.
\item output files: plots are extracted in memory.
\item \strong{select}: Read only the attributes of interest.
\item \strong{filter}: Read only the points of interest.
}
}

\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
SHPfile <- system.file("extdata", "efi_plot.shp", package="lidR")
las <- readLAS(LASfile)
inventory <- sf::st_read(SHPfile, quiet = TRUE)
inventory # contains an ID and a Value Of Interest (VOI) per plot

M <- plot_metrics(las, ~list(q85 = quantile(Z, probs = 0.85)), inventory, radius = 11.28)
model <- lm(VOI ~ q85, M)

M <- plot_metrics(las, .stdmetrics_z, inventory, radius = 11.28)

\dontrun{
# Works with polygons as well
inventory <- sf::st_buffer(inventory, 11.28)
plot(las@header)
plot(sf::st_geometry(inventory), add = TRUE)
M <- plot_metrics(las, .stdmetrics_z, inventory)
}
}
\seealso{
Other metrics: 
\code{\link{cloud_metrics}()},
\code{\link{grid_metrics}()},
\code{\link{point_metrics}()},
\code{\link{tree_metrics}()},
\code{\link{voxel_metrics}()}
}
\concept{metrics}
