% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aba.R
\name{ABAmodelPlot}
\alias{ABAmodelPlot}
\title{Plots observed VS values predicted in leave one out cross validation of an \code{\link{ABAmodel}}}
\usage{
ABAmodelPlot(modell, disp.text = F, col = NULL, ...)
}
\arguments{
\item{modell}{list. as returned by \code{\link{ABAmodel}}}

\item{disp.text}{boolean. indicates if points should be labeled with id}

\item{col}{color to be passed to \code{\link[graphics]{plot}}, default is black for single models, depends on stratum in stratified models}

\item{...}{other parameters to be passed to \code{\link[graphics]{plot}}, \code{xlab} and \code{ylab} are automatically setup}
}
\value{
nothing
}
\description{
Plots observed VS values predicted in leave one out cross validation of an \code{\link{ABAmodel}}
}
\examples{
# load Quatre Montagnes dataset
data(quatremontagnes)
# build ABA model for basal area, with all metrics as predictors
model.aba <- ABAmodel(quatremontagnes$G.m2.ha, quatremontagnes[, 9:76],
transform = "boxcox", nmax = 3)

# plot field values VS predictions in cross-validation
ABAmodelPlot(model.aba, main = "Basal area")
}
