% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.match.R
\name{plot2Dmatched}
\alias{plot2Dmatched}
\title{Plot of matched pairs of detected and reference trees}
\usage{
plot2Dmatched(lr, ld, matched, chm = NULL, plotBoundary = NULL, ...)
}
\arguments{
\item{lr}{data.frame or matrix. 3D coordinates (X Y Height) of reference positions}

\item{ld}{data.frame or matrix. 3D coordinates (X Y Height) of detected positions}

\item{matched}{data.frame. contains pair indices, typically returned by \code{\link{treeMatching}}}

\item{chm}{raster object. raster for background display}

\item{plotBoundary}{Spatialpolygon. plot boundaries for display}

\item{...}{Additional arguments to be used by \code{\link{plot}}}
}
\value{
no return
}
\description{
Plot of matched pairs of detected and reference trees
}
\examples{
# create reference and detected trees
ref.trees <- cbind(c(1,4,3,4,2), c(1,1.5,2,3,4), c(15,18,20,10,11))
def.trees <- cbind(c(2,2,4,4), c(1,3,4,1), c(16,19,9,15))
#
# compute matching
match1 <- treeMatching(ref.trees, def.trees)
match2 <- treeMatching(ref.trees, def.trees, deltaGround=2, hPrec=0)

# 2D display of matching results
plot2Dmatched(ref.trees, def.trees, match1, xlab="X", ylab="Y")
plot2Dmatched(ref.trees, def.trees, match2, xlab="X", ylab="Y")
}
\seealso{
\code{\link{treeMatching}}, \code{\link{histDetection}}
}
