% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.match.R
\name{treeMatching}
\alias{treeMatching}
\title{3D matching of detected tree top positions with reference positions}
\usage{
treeMatching(lr, ld, deltaGround = 2.1, hPrec = 0.14, computeStat = TRUE)
}
\arguments{
\item{lr}{data.frame or matrix. 3D coordinates (X Y Height) of reference positions}

\item{ld}{data.frame or matrix. 3D coordinates (X Y Height) of detected positions}

\item{deltaGround}{numeric. buffer around trunk position : absolute value}

\item{hPrec}{numeric. buffer around apex position : proportion of reference tree height}

\item{computeStat}{boolean. should matching stats be computed}
}
\value{
A data.frame with matched pairs (row of reference positions in first column, and row of detected positions in second column) and corresponding 3D distances
}
\description{
First computes a matching index for each potential pair associating a detected with a reference tree. This index is the 3D distance between detected and reference points, divided by a maximum matching distance set by user-defined parameters. Pairs with the lowest index are then iteratively associated.
}
\examples{
# create reference and detected trees
ref.trees <- cbind(c(1,4,3,4,2), c(1,1,2,3,4), c(15,18,20,10,11))
def.trees <- cbind(c(2,2,4,4), c(1,3,4,1), c(16,19,9,15))
#
# match trees
match1 <- treeMatching(ref.trees, def.trees)
match2 <- treeMatching(ref.trees, def.trees, deltaGround=2, hPrec=0)
match1
match2

# 2D display of matching result
plot2Dmatched(ref.trees, def.trees, match1, xlab="X", ylab="Y")
plot2Dmatched(ref.trees, def.trees, match2, xlab="X", ylab="Y")
}
\references{
Monnet, J.-M. 2011. Using airborne laser scanning for mountain forests mapping: Support vector regression for stand parameters estimation and unsupervised training for treetop detection. Ph.D. thesis. University of Grenoble, France. pp. 53-55 \url{https://tel.archives-ouvertes.fr/tel-00652698/document}

Monnet, J.-M., Mermin, E., Chanussot, J., Berger, F. 2010. Tree top detection using local maxima filtering: a parameter sensitivity analysis. Silvilaser 2010, the 10th International Conference on LiDAR Applications for Assessing Forest Ecosystems, September 14-17, Freiburg, Germany, 9 p. \url{https://hal.archives-ouvertes.fr/hal-00523245/document}
}
\seealso{
\code{\link{plot2Dmatched}}, \code{\link{histDetection}}
}
