% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\docType{data}
\name{aba_metrics}
\alias{aba_metrics}
\alias{.aba_metrics}
\title{Function for area-based metrics computation}
\format{
An object of class \code{formula} of length 2.
}
\usage{
aba_metrics(z, i, rn, c, hmin = 2, breaksH = NULL)

.aba_metrics
}
\arguments{
\item{z, i, rn, c}{Height, Intensity, ReturnNumber and Classification}

\item{hmin}{numeric. height threshold for low points removal before metrics
computation}

\item{breaksH}{vector. breaks for height histogram proportion computation}
}
\description{
Predefined function usable in \code{\link[lidR]{cloud_metrics}} or
\code{\link{clouds_metrics}}. Applies a minimum height threshold to the point
cloud and computes the following metrics:
\enumerate{
\item for all points: total number \code{ntot}, percentage of points above
minimum height \code{p_hmin}, percentage of points in height bins
\code{H.propZ1_Z2},
\item for first return points: percentage above minimum height
\code{p_1st_hmin},
\item for all points above minimum height: height metrics returned by
\code{\link[lidR]{stdmetrics_z}} and intensity metrics returned by
\code{\link[lidR]{stdmetrics_i}}
\item for first returns above minimum height: \code{mCH} and \code{sdCH} as
proposed by Bouvier et al.
}
}
\examples{
data(las_chablais3)

# extract four point clouds from LAS object
llas <- list()
llas[["A"]] <- lidR::clip_circle(las_chablais3, 974350, 6581680, 10)
llas[["B"]] <- lidR::clip_circle(las_chablais3, 974390, 6581680, 10)
llas[["C"]] <- lidR::clip_circle(las_chablais3, 974350, 6581640, 10)
# normalize point clouds
llas <- lapply(llas, function(x) {
  lidR::normalize_height(x, lidR::tin())
})

# compute metrics
clouds_metrics(llas, ~ aba_metrics(
  Z, Intensity, ReturnNumber, Classification, 2, c(-Inf, 0, 2, 10, 20, +Inf)
))
}
\references{
Bouvier et al. 2015. Generalizing predictive models of forest
inventory attributes using an area-based approach with airborne LiDAR data.
Remote Sensing of Environment 156, pp. 322-334. \doi{10.1016/j.rse.2014.10.004}
}
\seealso{
\code{\link[lidR]{cloud_metrics}}, \code{\link[lidR]{stdmetrics}},
\code{\link{clouds_metrics}}
}
\keyword{datasets}
