% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_detection.R
\name{tree_extraction}
\alias{tree_extraction}
\title{Tree extraction}
\usage{
tree_extraction(r_dem_nl, r_maxi, r_dem_w, r_mask = NULL)
}
\arguments{
\item{r_dem_nl}{raster object. raster of canopy height model, preferably filtered to avoid effect of holes on volume and surface computation}

\item{r_maxi}{raster object. raster positive values at local maxima}

\item{r_dem_w}{raster object. segmented raster}

\item{r_mask}{raster object. only segments which maxima are inside the mask are extracted}
}
\value{
A spatial data.frame with tree id, local maximum stats (height, dominance radius), segment stats (surface and volume).
}
\description{
creates a dataframe with segment id, height and coordinates of maxima, surface and volume, computed from three images: initial, local maxima and segmented, obtained with \code{\link{tree_segmentation}}
}
\examples{
data(chm_chablais3)

# tree segmentation
segments <- tree_segmentation(chm_chablais3)

# tree extraction
trees <- tree_extraction(
  segments$filled_dem, segments$local_maxima,
  segments$segments_id
)
trees

# plot initial image
raster::plot(chm_chablais3)

# add treetop positions
sp::plot(trees, cex = trees$h / 20, add = TRUE, pch = 1)
\donttest{
# add segment contours (vectorization is slow)
contours <- raster::rasterToPolygons(segments$segments_id, dissolve = TRUE)
sp::plot(contours, add = TRUE, border = "white")
}

}
\seealso{
\code{\link{tree_segmentation}}
}
