% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster_metrics.R
\name{raster_metrics}
\alias{raster_metrics}
\title{Computes metrics by aggregating a raster at lower resolution or summarizing
attributes based on XY locations}
\usage{
raster_metrics(
  r,
  res = 20,
  fun = function(x) {     data.frame(mean = mean(x$layer), sd = stats::sd(x$layer)) },
  output = "raster"
)
}
\arguments{
\item{r}{raster object or data.frame with xy coordinates in two first columns}

\item{res}{numeric. Resolution of the aggregation raster, should be a multiple
of r resolution if a raster is provided}

\item{fun}{function. Function to compute metrics in each aggregated cell from
the values contained in the initial raster (use x$layer to access raster
values) / data.frame (use x$colum_name to access values)}

\item{output}{string. indicates the class of output object "raster" or "data.frame"}
}
\value{
a data.frame with the XY center coordinates of the aggregated cells,
and the values computed with the user-specified function or a Raster object
}
\description{
Compute statistics by aggregating a raster at lower resolution. Aggregation
groups are larger cells, new values are computed by applying a user-specified
function to original cells contained in the larger cells. Results are provided
as a data.frame which also contains the XY coordinates of the larger cells.
}
\examples{
data(chm_chablais3)

# raster metrics from raster
metrics1 <- raster_metrics(chm_chablais3, res = 10)
metrics1

# raster metrics from data.frame
n <- 1000
df <- data.frame(
  x = runif(n, 0, 100), y = runif(n, 0, 100), z1 = runif(n, 0, 1),
  z2 = runif(n, 10, 20)
)
# compute raster metrics
metrics2 <- raster_metrics(df,
  res = 10,
  fun = function(x) {
    data.frame(max.z = max(x$z1), max.sum = max(x$z1 + x$z2))
  },
  output = "data.frame"
)
summary(metrics2)

# display raster metrics
raster::plot(metrics1)
# display data.frame metrics
raster::plot(raster::rasterFromXYZ(metrics2))
}
