% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{raster_chull_mask}
\alias{raster_chull_mask}
\title{Raster mask of convex hull}
\usage{
raster_chull_mask(xy, r)
}
\arguments{
\item{xy}{2 columns matrix or data.frame. xy positions}

\item{r}{raster object. target raster}
}
\value{
a SpatRaster with 0 or 1
}
\description{
creates raster mask corresponding to the convex hull of xy positions
}
\examples{
# create raster
r <- terra::rast(extent = c(0, 40, 0, 40), resolution = 1, crs = "epsg:2154")


# xy positions
xy <- data.frame(
  x = c(10, 20, 31.25, 15),
  y = c(10, 20, 31.25, 25)
)
# compute mask
mask1 <- raster_chull_mask(xy, r)

# display binary raster
terra::plot(mask1)
graphics::points(xy)
}
\seealso{
\code{\link{raster_xy_mask}}
}
