% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{points2DTM}
\alias{points2DTM}
\title{Digital Terrain Model}
\usage{
points2DTM(.las, res = 1, xmin, xmax, ymin, ymax)
}
\arguments{
\item{.las}{\code{\link[lidR]{LAS}} object or XYZ matrix/data.frame containing 
only ground points}

\item{res}{numeric. raster resolution}

\item{xmin}{numeric. lower left corner easting coordinate for output raster.}

\item{xmax}{numeric. upper right corner easting coordinate for output raster.}

\item{ymin}{numeric. lower left corner northing coordinate for output raster.}

\item{ymax}{numeric. upper right corner northing coordinate for output raster.}
}
\value{
A SpatRaster object
}
\description{
Creates a Digital Terrain Model from LAS object or XYZ data. Raster extent is
specified by the coordinates of lower left and upper right corners. Default 
extent covers the full range of points, and aligns on multiple values of the 
resolution. Cell value is compute as the bilinear interpolation at the cell 
center form an Delaunay triangulation. Relies on \code{\link[lidR]{rasterize_terrain}} 
with algorithm \code{\link[lidR]{tin}}. In case a LAS object is provided, only 
points classified as ground or water (2 or 9) will be used.
}
\examples{
# load LAS file
LASfile <- system.file("extdata", "las_chablais3.laz", package="lidaRtRee")
las_chablais3 <- lidR::readLAS(LASfile)
# set projection
lidR::projection(las_chablais3) <- 2154

# create digital terrain model with points classified as ground
dtm <- points2DTM(las_chablais3)

# display raster
terra::plot(dtm)
}
\seealso{
\code{\link{points2DSM}} for Digital Surface Model computation.
}
