% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lgb.Dataset.R
\name{get_field}
\alias{get_field}
\alias{get_field.lgb.Dataset}
\title{Get one attribute of a \code{lgb.Dataset}}
\usage{
get_field(dataset, field_name)

\method{get_field}{lgb.Dataset}(dataset, field_name)
}
\arguments{
\item{dataset}{Object of class \code{lgb.Dataset}}

\item{field_name}{String with the name of the attribute to get. One of the following.
\itemize{
    \item \code{label}: label lightgbm learns from ;
    \item \code{weight}: to do a weight rescale ;
    \item{\code{group}: used for learning-to-rank tasks. An integer vector describing how to
        group rows together as ordered results from the same set of candidate results to be ranked.
        For example, if you have a 100-document dataset with \code{group = c(10, 20, 40, 10, 10, 10)},
        that means that you have 6 groups, where the first 10 records are in the first group,
        records 11-30 are in the second group, etc.}
    \item \code{init_score}: initial score is the base prediction lightgbm will boost from.
}}
}
\value{
requested attribute
}
\description{
Get one attribute of a \code{lgb.Dataset}
}
\examples{
\donttest{
data(agaricus.train, package = "lightgbm")
train <- agaricus.train
dtrain <- lgb.Dataset(train$data, label = train$label)
lgb.Dataset.construct(dtrain)

labels <- lightgbm::get_field(dtrain, "label")
lightgbm::set_field(dtrain, "label", 1 - labels)

labels2 <- lightgbm::get_field(dtrain, "label")
stopifnot(all(labels2 == 1 - labels))
}
}
