% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lgb.interprete.R
\name{lgb.interprete}
\alias{lgb.interprete}
\title{Compute feature contribution of prediction}
\usage{
lgb.interprete(model, data, idxset, num_iteration = NULL)
}
\arguments{
\item{model}{object of class \code{lgb.Booster}.}

\item{data}{a matrix object or a dgCMatrix object.}

\item{idxset}{an integer vector of indices of rows needed.}

\item{num_iteration}{number of iteration want to predict with, NULL or <= 0 means use best iteration.}
}
\value{
For regression, binary classification and lambdarank model, a \code{list} of \code{data.table}
        with the following columns:
        \itemize{
            \item{\code{Feature}: Feature names in the model.}
            \item{\code{Contribution}: The total contribution of this feature's splits.}
        }
        For multiclass classification, a \code{list} of \code{data.table} with the Feature column and
        Contribution columns to each class.
}
\description{
Computes feature contribution components of rawscore prediction.
}
\examples{
\donttest{
\dontshow{setLGBMthreads(2L)}
\dontshow{data.table::setDTthreads(1L)}
Logit <- function(x) log(x / (1.0 - x))
data(agaricus.train, package = "lightgbm")
train <- agaricus.train
dtrain <- lgb.Dataset(train$data, label = train$label)
set_field(
  dataset = dtrain
  , field_name = "init_score"
  , data = rep(Logit(mean(train$label)), length(train$label))
)
data(agaricus.test, package = "lightgbm")
test <- agaricus.test

params <- list(
    objective = "binary"
    , learning_rate = 0.1
    , max_depth = -1L
    , min_data_in_leaf = 1L
    , min_sum_hessian_in_leaf = 1.0
    , num_threads = 2L
)
model <- lgb.train(
    params = params
    , data = dtrain
    , nrounds = 3L
)

tree_interpretation <- lgb.interprete(model, test$data, 1L:5L)
}
}
