\name{evaluate.peaks} 
\alias{evaluate.peaks} 
\title{likeLTD::evaluate.peaks} 
\usage{evaluate.peaks(P.pars, D.pars, tolerance=1e-6, n.steps=NULL, interim=TRUE, 
CR.start=0.1, CR.end=0.7, seed.input=NULL, converge=TRUE, nConverged=5)}
\arguments{
  \item{P.pars}{Parameters for prosecution hypothesis, as generated by optimisation.params.peaks.}
  \item{D.pars}{Parameters for prosecution hypothesis, as generated by optimisation.params.peaks.}
  \item{tolerance}{Tolerance for optimisation. Optimisation continues until the last \code{nConverged} 
	chunks have a relative difference between the current result and them less than this value.}
  \item{n.steps}{Number of steps to run. Defaults to NULL. if n.steps is NULL , the number
	of steps to run is determined by the mean of the standard deviation of the initial phase of 
	the intial chunk of optimisation for prosecution and defence. }
  \item{interim}{Logical, stating whether or not to generate interim reports. If set to TRUE a basic set 
	of results after each step is output to "Interim.csv", and an image of the content of evaluate() or 
	evaluate.from.interim() "interim.RData" are both stored in the current working directory. The latter can 
	be used by evaluate.from.interim() to continue an evaluation from its previous state. Each step will 
	write over the results from the previous step.}
  \item{CR.start}{Numerical, between 0 and 1, used by DEoptim as CR argument, at the start of the search. 
	Gradually moves towards CR.end to allow a broader initial search, gradually becoming more localised in 
	parameter space. See DEoptim for further details.}
  \item{CR.end}{Numerical, between 0 and 1,see details for CR.start.}
  \item{seed.input}{An integer that should be specified if the user wishes to set a particular seed. If not
	specified, the program sets the seed to an integer representation of the present time, date and process ID.}
  \item{converge}{Logical. Whether or not to check for convergence of the last nConverged steps to the global best values.}
  \item{nConverged}{The number of steps with relitive difference to the current results less than \code{tolerance}
	that determines convergence.}

}
\value{
A list containing seven elements:
\item{Pros}{Prosecution results, structured as results from DEoptim::DEoptim.}
\item{Def}{Defence results, structured as results from DEoptim::DEoptim.}
\item{WoE}{WoE for each chunk. The final value is the final WoE.}
\item{Lp}{-log_{10} prosecution likelihood at each step usually.}
\item{Ld}{-log_{10} defence likelihood at each step usually.}
\item{seed.used}{Seed that is set at the beginning of computation.}
\item{seed.input}{Seed that is input by the user.}
\item{runtime}{List of three objects: elapsed, start, end. \code{runtime$start} and \code{runtime$end} are obtained through \code{Sys.time} at the beginning and end of computation, \code{runtime$elapsed} is obtained by \code{difftime} on \code{runtime$start} and \code{runtime$end}.}
} 
\description{
Optimize both prosecution and defence likelihoods, returning the weight of evidence for peak height data.
}
\details{
  Optimize over parameter space, using a geometric progression of crossover rate and tolerance.
The defence hypothesis is optimised before the prosecution hypothesis, with the result used to constrain 
some of the parameters of the prosecution optiimisation.
}
\seealso{DEoptim,DEoptimLoop}
\examples{
\dontrun{
# datapath to example files
datapath = file.path(system.file("extdata", package="likeLTD"),"laboratory")

# File paths and case name for allele report
admin = pack.admin.input.peaks(
            peaksFile = file.path(datapath, 'laboratory-CSP.csv'),
            refFile = file.path(datapath, 'laboratory-reference.csv'),
            caseName = "Laboratory",
            detectionThresh = 20
             )

# Enter arguments
args = list(
        nUnknowns = 1
        )

# Create hypotheses
hypP = do.call(prosecution.hypothesis.peaks, append(admin,args))
hypD = do.call(defence.hypothesis.peaks, append(admin,args))

# Get parameters for optimisation
paramsP = optimisation.params.peaks(hypP)
paramsD = optimisation.params.peaks(hypD)

# reduce number of iterations for demonstration purposes
paramsP$control$itermax=25
paramsD$control$itermax=25

# Run optimisation
# n.steps and converge set for demonstration purposes
results = evaluate.peaks(paramsP, paramsD, n.steps=1, 
      converge=FALSE)
}
}


