% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lyl_plot.R
\name{lyl_checkplot}
\alias{lyl_checkplot}
\title{Plot number of persons at risk at each specific age.}
\usage{
lyl_checkplot(x)
}
\arguments{
\item{x}{An object of class \code{lyl_range} obtained with the \code{lyl_range} function.}
}
\value{
A plot with the number of persons at risk at each specific age.
}
\description{
Given a \code{lyl_range}-class object, \code{lyl_checkplot} draws numbers of persons at risk of
dying at each specific age from \code{age_begin} until age \eqn{\tau}.
}
\examples{
# Load simulated data as example
data(simu_data)

# Estimate remaining life expectancy and Life Years
# Lost after each age from 0 to 94 years and before age 95 years
lyl_estimation <- lyl_range(data = simu_data, t = age_death, status = death,
                            age_begin = 45, age_end = 50, tau = 95)

# Check whether small numbers could compromise the results
lyl_checkplot(lyl_estimation)

# The plot can be modified with a usual ggplot2 format
lyl_checkplot(lyl_estimation) +
  ggplot2::geom_hline(yintercept = 10, linetype = "dashed", color = "red") +
  ggplot2::xlab("Age [in years]") +
  ggplot2::ggtitle("Persons at risk of dying at each age 0-94 years")

}
\seealso{
\code{\link{lyl_range}} for estimation of Life Years Lost for a range of different ages.

% @references \itemize{
    % \item{Plana-Ripoll et al. lillies – An R package for the estimation of excess Life Years Lost among patients with a given disease or condition. \emph{In preparation}.}
% }
}
