% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tour-linked-scatter.R
\name{limn_tour_link}
\alias{limn_tour_link}
\title{Link a 2-d embedding with a tour}
\usage{
limn_tour_link(
  embed_data,
  tour_data,
  cols = NULL,
  color = NULL,
  tour_path = tourr::grand_tour(),
  rescale = clamp,
  morph = "center",
  gadget_mode = TRUE
)
}
\arguments{
\item{embed_data}{A \code{data.frame} representing embedding coordinates}

\item{tour_data}{a data.frame to tour}

\item{cols}{Columns to tour. This can use a tidyselect specification
such as \code{\link[tidyselect:starts_with]{tidyselect::starts_with()}}.}

\item{color}{A variable mapping to the color aesthetic, if
NULL points will be colored black.}

\item{tour_path}{the tour path to take, the default is \code{\link[tourr:grand_tour]{tourr::grand_tour()}}
but also works with \code{\link[tourr:guided_tour]{tourr::guided_tour()}}.}

\item{rescale}{A function that rescales \code{cols}, the default is to
\code{\link[=clamp]{clamp()}} the data to lie in the hyperdimensional unit cube. To not perform
any scaling use \code{\link[=identity]{identity()}}.}

\item{morph}{One of \code{c("center", "centre", "identity", "radial")}
that rescales each projection along the tour path. The default
is to center the projections and divide by half range. See \code{\link[=morph_center]{morph_center()}}
for details.}

\item{gadget_mode}{Run the app as a \code{\link[shiny:runGadget]{shiny::runGadget()}} which will load
the app in the RStudio Viewer pane or a browser (default = TRUE). If FALSE
will return a regular shiny app object that could be used to deploy the app
elsewhere.}
}
\value{
After pressing the Done button on the interface, a list of artefacts
is returned to the R session.
\itemize{
\item \code{selected_basis}: A matrix of the current projection
\item \code{tour_brush_box}: A list containing the bounding box of the  tour brush
\item \code{embed_brush_box}: A list containing the bounding box of the embed brush
\item \code{tour_half_range}: The current value of the half range
}
}
\description{
Link a 2-d embedding with a tour
}
\details{
All controls for the app can be obtained by clicking on the help button,
in the bottom panel. More details are described below:
\itemize{
\item The tour view on the left is a dynamic and interactive scatterplot. Brushing on the tour view
is activated with the shift key plus a mouse drag. By default it will
highlight corresponding points in the xy view and pause the animation.
\item The xy view on the right is an interactive scatterplot. Brushing on the xy view
will highlight points in the tour view and is activated via a mouse drag,
the type of highlighting depends on the brush mode selected.
\item There is a play button, that when pressed will start the tour.
\item The half range which is the maximum squared
Euclidean distance between points in the tour view. The half range
is a scale factor for projections and can be thought of as a way
of zooming in and out on points. It can be dynamically modified by scrolling
(via a mouse-wheel). To reset double click the tour view.
\item The legend can be toggled to highlight groups of points with
shift+mouse-click. Multiple groups can be selected in this way. To
reset double click the legend title.
}
}
\examples{
if (interactive()) {
  # tour the first ten columns of the fake tree data and link to the
  # another layout based on t-SNE
  # loads the default interface
  if (requireNamespace("Rtsne", quietly = TRUE)) {
    set.seed(2020)
    tsne <- Rtsne::Rtsne(dplyr::select(fake_trees, dplyr::starts_with("dim")))
    tsne_df <- data.frame(tsneX = tsne$Y[, 1], tsneY = tsne$Y[, 2])
    limn_tour_link(
      tsne_df,
      fake_trees,
      cols = dim1:dim10,
      color = branches
    )
    # assigning to an object will return a list of artefacts after clicking
    # done in the upper right hand corner
    res <- limn_tour_link(tsne_df, fake_trees, cols = dim1:dim10, color = branches)
  }
}
}
